/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.base.Strings;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error6Parser
extends AbstractAaptOutputParser {
    private static final Pattern MSG_PATTERN = Pattern.compile("^ERROR:\\s+9-patch\\s+image\\s+(.+)\\s+malformed\\.$");

    Error6Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m3 = MSG_PATTERN.matcher(line);
        if (!m3.matches()) {
            return false;
        }
        String sourcePath = m3.group(1);
        String msgText = line;
        if (reader.hasNextLine()) {
            msgText = Strings.nullToEmpty(reader.readLine()).trim();
            if (reader.hasNextLine()) {
                msgText = msgText + " - " + Strings.nullToEmpty(reader.readLine()).trim();
                reader.skipNextLine();
            }
        }
        Message msg = Error6Parser.createMessage(Message.Kind.ERROR, msgText, sourcePath, null, "", logger);
        messages.add(msg);
        return true;
    }
}

