/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error1Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of(Pattern.compile("^ERROR\\s+at\\s+line\\s+(\\d+):\\s+(.*)$"), Pattern.compile("^\\s+\\(Occurred while parsing\\s+(.*)\\)$"));

    Error1Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m3 = MSG_PATTERNS.get(0).matcher(line);
        if (!m3.matches()) {
            return false;
        }
        String lineNumber = m3.group(1);
        String msgText = m3.group(2);
        m3 = Error1Parser.getNextLineMatcher(reader, MSG_PATTERNS.get(1));
        if (m3 == null) {
            throw new ParsingFailedException();
        }
        String sourcePath = m3.group(1);
        Message msg = Error1Parser.createMessage(Message.Kind.ERROR, msgText, sourcePath, lineNumber, "", logger);
        messages.add(msg);
        return true;
    }
}

