/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.aapt.ReadOnlyDocument;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.resources.ResourceFolderType;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@VisibleForTesting
public abstract class AbstractAaptOutputParser
implements PatternAwareOutputParser {
    private static final Pattern PROPERTY_NAME_AND_VALUE = Pattern.compile("\\(at '(.+)' with value '(.*)'\\)");
    private static final Pattern REPEATED_RESOURCE = Pattern.compile("Resource entry (.+) already has bag item (.+)\\.");
    private static final String ORIGINALLY_DEFINED_HERE = "Originally defined here.";
    private static final Pattern NO_RESOURCE_FOUND = Pattern.compile("No resource found that matches the given name: attr '(.+)'\\.");
    private static final Pattern REQUIRED_ATTRIBUTE = Pattern.compile("A '(.+)' attribute is required for <(.+)>");
    private static final String START_MARKER = "<!-- From: ";
    private static final String END_MARKER = " -->";
    private static final Cache<String, ReadOnlyDocument> ourDocumentsByPathCache = CacheBuilder.newBuilder().weakValues().build();
    public static final String AAPT_TOOL_NAME = "AAPT";
    @VisibleForTesting
    public static File ourRootDir;

    private static SourcePosition findMessagePositionInFile(File file, String msgText, int locationLine, ILogger logger) {
        SourcePosition exactPosition = AbstractAaptOutputParser.findExactMessagePositionInFile(file, msgText, locationLine, logger);
        if (exactPosition != null) {
            return exactPosition;
        }
        return new SourcePosition(locationLine, -1, -1);
    }

    private static SourcePosition findExactMessagePositionInFile(File file, String msgText, int locationLine, ILogger logger) {
        Matcher matcher = PROPERTY_NAME_AND_VALUE.matcher(msgText);
        if (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!value.isEmpty()) {
                return AbstractAaptOutputParser.findText(file, name, value, locationLine, logger);
            }
            SourcePosition position1 = AbstractAaptOutputParser.findText(file, name, "\"\"", locationLine, logger);
            SourcePosition position2 = AbstractAaptOutputParser.findText(file, name, "''", locationLine, logger);
            if (position1 == null) {
                if (position2 == null) {
                    return AbstractAaptOutputParser.findText(file, name, null, locationLine, logger);
                }
                return position2;
            }
            if (position2 == null) {
                return position1;
            }
            if (position1.getStartOffset() < position2.getStartOffset()) {
                return position1;
            }
            return position2;
        }
        matcher = REPEATED_RESOURCE.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine, logger);
        }
        matcher = NO_RESOURCE_FOUND.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(1);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine, logger);
        }
        matcher = REQUIRED_ATTRIBUTE.matcher(msgText);
        if (matcher.find()) {
            String elementName = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, '<' + elementName, null, locationLine, logger);
        }
        if (msgText.endsWith(ORIGINALLY_DEFINED_HERE)) {
            return AbstractAaptOutputParser.findLineStart(file, locationLine, logger);
        }
        return null;
    }

    private static SourcePosition findText(File file, String first, String second, int locationLine, ILogger logger) {
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        int offset = document.lineOffset(locationLine);
        if ((long)offset == -1L) {
            return null;
        }
        int resultOffset = document.findText(first, offset);
        if ((long)resultOffset == -1L) {
            return null;
        }
        if (second != null && (long)(resultOffset = document.findText(second, resultOffset + first.length())) == -1L) {
            return null;
        }
        int startLineNumber = document.lineNumber(resultOffset);
        int startLineOffset = document.lineOffset(startLineNumber);
        int endResultOffset = resultOffset + (second != null ? second.length() : first.length());
        int endLineNumber = document.lineNumber(endResultOffset);
        int endLineOffset = document.lineOffset(endLineNumber);
        return new SourcePosition(startLineNumber, resultOffset - startLineOffset, resultOffset, endLineNumber, endResultOffset - endLineOffset, endResultOffset);
    }

    private static SourcePosition findLineStart(File file, int locationLine, ILogger logger) {
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        int lineOffset = document.lineOffset(locationLine);
        if ((long)lineOffset == -1L) {
            return null;
        }
        int nextLineOffset = document.lineOffset(locationLine + 1);
        if (nextLineOffset == -1) {
            nextLineOffset = document.length();
        }
        int resultOffset = -1;
        for (int i2 = lineOffset; i2 < nextLineOffset; ++i2) {
            char c = document.charAt(i2);
            if (Character.isWhitespace(c)) continue;
            resultOffset = i2;
            break;
        }
        if ((long)resultOffset == -1L) {
            return null;
        }
        int endResultOffset = resultOffset;
        for (int i3 = nextLineOffset - 1; i3 >= resultOffset; --i3) {
            char c = document.charAt(i3);
            if (Character.isWhitespace(c)) continue;
            endResultOffset = i3;
            break;
        }
        return new SourcePosition(locationLine, resultOffset - lineOffset, resultOffset, locationLine, endResultOffset - lineOffset, endResultOffset);
    }

    private static ReadOnlyDocument getDocument(File file, ILogger logger) {
        String filePath = file.getAbsolutePath();
        ReadOnlyDocument document = ourDocumentsByPathCache.getIfPresent(filePath);
        if (document == null || document.isStale()) {
            try {
                if (!file.exists()) {
                    if (ourRootDir != null && ourRootDir.isAbsolute() && !file.isAbsolute()) {
                        file = new File(ourRootDir, file.getPath());
                        return AbstractAaptOutputParser.getDocument(file, logger);
                    }
                    return null;
                }
                document = new ReadOnlyDocument(file);
                ourDocumentsByPathCache.put(filePath, document);
            }
            catch (IOException e) {
                String format = "Unexpected error occurred while reading file '%s' [%s]";
                logger.warning(format, file.getAbsolutePath(), e);
                return null;
            }
        }
        return document;
    }

    private static String urlToPath(String url) {
        if (url.startsWith("file:")) {
            String prefix = url.startsWith("file://") ? "file://" : "file:";
            return url.substring(prefix.length());
        }
        return url;
    }

    public static SourcePosition findResourceLine(File file, String key, ILogger logger) {
        int slash = key.indexOf(47);
        if (slash == -1) {
            assert (false) : slash;
            return SourcePosition.UNKNOWN;
        }
        String type2 = key.substring(0, slash);
        String name = key.substring(slash + 1);
        return AbstractAaptOutputParser.findValueDeclaration(file, type2, name, logger);
    }

    public static SourcePosition findValueDeclaration(File file, String type2, String name, ILogger logger) {
        if (!file.exists()) {
            return SourcePosition.UNKNOWN;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return SourcePosition.UNKNOWN;
        }
        int index = document.findText(name, 0);
        if (index == -1) {
            return SourcePosition.UNKNOWN;
        }
        if (document.findText(name, index + name.length()) == -1) {
            return document.sourcePosition(index);
        }
        int nameIndex = document.findText("name=\"" + name + "\"", 0);
        if (nameIndex != -1) {
            return document.sourcePosition(nameIndex);
        }
        SourcePosition lineNumber = AbstractAaptOutputParser.findValueDeclarationViaParse(type2, name, document);
        if (!SourcePosition.UNKNOWN.equals(lineNumber)) {
            return lineNumber;
        }
        assert (index != -1);
        return document.sourcePosition(index);
    }

    private static SourcePosition findValueDeclarationViaParse(final String type2, final String name, ReadOnlyDocument document) {
        int endColumn;
        int endLineNumber;
        final int[] certain = new int[]{-1, 0};
        final int[] possible = new int[]{-1, 0};
        final AtomicReference<Integer> line = new AtomicReference<Integer>(-1);
        DefaultHandler handler = new DefaultHandler(){
            private int myDepth;
            private Locator myLocator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.myLocator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                ++this.myDepth;
                if (this.myDepth == 2 && name.equals(attributes.getValue("name"))) {
                    int lineNumber = this.myLocator.getLineNumber() - 1;
                    int column = this.myLocator.getColumnNumber() - 1;
                    if (qName.equals(type2) || "item".equals(qName) && type2.equals(attributes.getValue("type"))) {
                        line.set(lineNumber);
                        certain[0] = lineNumber;
                        certain[1] = column;
                    } else if ((Integer)line.get() < 0) {
                        line.set(-lineNumber);
                        possible[0] = lineNumber;
                        possible[1] = column;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                --this.myDepth;
            }
        };
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            XmlUtils.configureSaxFactory(factory, false, false);
            SAXParser saxParser = XmlUtils.createSaxParser(factory);
            saxParser.parse(new InputSource(new StringReader(document.getContents())), handler);
        }
        catch (Throwable saxParser) {
            // empty catch block
        }
        if (certain[0] != -1) {
            endLineNumber = certain[0];
            endColumn = certain[1];
        } else {
            endLineNumber = possible[0];
            endColumn = possible[1];
        }
        if (endLineNumber != -1) {
            int endOffset = document.lineOffset(endLineNumber) + endColumn;
            int offset = document.findTextBackwards(name, endOffset);
            if (offset != -1) {
                SourcePosition start = document.sourcePosition(offset);
                return new SourcePosition(start.getStartLine(), start.getStartColumn(), start.getStartOffset(), endLineNumber, endColumn, endOffset);
            }
            return new SourcePosition(endLineNumber, endColumn, endOffset);
        }
        return SourcePosition.UNKNOWN;
    }

    static Matcher getNextLineMatcher(OutputLineReader reader, Pattern pattern) {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        Matcher m3 = pattern.matcher(line);
        return m3.matches() ? m3 : null;
    }

    static Message createMessage(Message.Kind kind, String text, String sourcePath, String lineNumberAsText, String startColumnAsText, String endColumnAsText, String original, ILogger logger) throws ParsingFailedException {
        SourceFilePosition source;
        File file = null;
        if (sourcePath != null && !(file = new File(sourcePath)).isFile()) {
            throw new ParsingFailedException();
        }
        SourcePosition errorPosition = AbstractAaptOutputParser.parseErrorPosition(lineNumberAsText, startColumnAsText, endColumnAsText);
        if (file != null && (source = AbstractAaptOutputParser.findSourcePosition(file, errorPosition.getStartLine(), text, logger)) != null) {
            file = source.getFile().getSourceFile();
            if (source.getPosition().getStartLine() != -1) {
                errorPosition = source.getPosition();
            }
        }
        if (file != null && errorPosition.getStartLine() != -1 && errorPosition.getStartColumn() == -1) {
            errorPosition = AbstractAaptOutputParser.findMessagePositionInFile(file, text, errorPosition.getStartLine(), logger);
        }
        return new Message(kind, text, original, AAPT_TOOL_NAME, file == null ? SourceFilePosition.UNKNOWN : new SourceFilePosition(file, errorPosition), new SourceFilePosition[0]);
    }

    static Message createMessage(Message.Kind kind, String text, String sourcePath, String lineNumberAsText, String original, ILogger logger) throws ParsingFailedException {
        return AbstractAaptOutputParser.createMessage(kind, text, sourcePath, lineNumberAsText, null, null, original, logger);
    }

    private static SourcePosition parseErrorPosition(String lineNumberAsText, String startColumnAsText, String endColumnAsText) throws ParsingFailedException {
        int endColumn;
        int lineNumber = 0;
        int startColumn = 0;
        if (lineNumberAsText != null) {
            try {
                lineNumber = Integer.parseInt(lineNumberAsText);
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException();
            }
        }
        if (startColumnAsText != null) {
            try {
                startColumn = Integer.parseInt(startColumnAsText);
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException();
            }
        }
        if (endColumnAsText != null) {
            try {
                endColumn = Integer.parseInt(endColumnAsText);
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException();
            }
        } else {
            endColumn = startColumn;
        }
        return new SourcePosition(lineNumber - 1, startColumn - 1, -1, lineNumber - 1, endColumn - 1, -1);
    }

    protected static SourceFilePosition findSourcePosition(File file, int locationLine, String message, ILogger logger) {
        File sourceFile;
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        String fileName = file.getName();
        boolean isManifest = fileName.equals("AndroidManifest.xml");
        boolean isValueFile = fileName.startsWith(ResourceFolderType.VALUES.getName());
        int searchStart = isValueFile || isManifest ? document.lineOffset(locationLine) : document.length();
        if ((long)searchStart == -1L) {
            return null;
        }
        int start = document.findTextBackwards(START_MARKER, searchStart);
        assert (start < searchStart);
        if (start == -1 && isManifest && searchStart < document.length() && (long)(searchStart = document.length()) != -1L) {
            start = document.findTextBackwards(START_MARKER, searchStart);
            assert (start < searchStart);
        }
        if (start == -1) {
            return null;
        }
        int end = document.findText(END_MARKER, start += START_MARKER.length());
        if (end == -1) {
            return null;
        }
        String sourcePath = document.subsequence(start, end);
        if (sourcePath.startsWith("file:")) {
            String originalPath = sourcePath;
            sourceFile = new File(sourcePath = AbstractAaptOutputParser.urlToPath(sourcePath));
            if (!sourceFile.exists()) {
                try {
                    sourceFile = SdkUtils.urlToFile(originalPath);
                }
                catch (MalformedURLException e) {
                    logger.warning("Invalid file URL: " + originalPath, new Object[0]);
                }
            }
        } else {
            sourceFile = new File(sourcePath);
        }
        if (isValueFile) {
            SourcePosition position = AbstractAaptOutputParser.findMessagePositionInFile(sourceFile, message, 1, logger);
            return new SourceFilePosition(new SourceFile(sourceFile), position);
        }
        return new SourceFilePosition(new SourceFile(sourceFile), SourcePosition.UNKNOWN);
    }
}

