/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFileJsonTypeAdapter;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.SourcePositionJsonTypeAdapter;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class SourceFilePositionJsonSerializer
extends TypeAdapter<SourceFilePosition> {
    private static final String POSITION = "position";
    private static final String FILE = "file";
    private final SourceFileJsonTypeAdapter mSourceFileJsonTypeAdapter;
    private final SourcePositionJsonTypeAdapter mSourcePositionJsonTypeAdapter = new SourcePositionJsonTypeAdapter();

    public SourceFilePositionJsonSerializer() {
        this.mSourceFileJsonTypeAdapter = new SourceFileJsonTypeAdapter();
    }

    @Override
    public SourceFilePosition read(JsonReader in) throws IOException {
        in.beginObject();
        SourceFile file = SourceFile.UNKNOWN;
        SourcePosition position = SourcePosition.UNKNOWN;
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals(FILE)) {
                file = this.mSourceFileJsonTypeAdapter.read(in);
                continue;
            }
            if (name.equals(POSITION)) {
                position = this.mSourcePositionJsonTypeAdapter.read(in);
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return new SourceFilePosition(file, position);
    }

    @Override
    public void write(JsonWriter out, SourceFilePosition src) throws IOException {
        SourcePosition position;
        out.beginObject();
        SourceFile sourceFile = src.getFile();
        if (!sourceFile.equals(SourceFile.UNKNOWN)) {
            out.name(FILE);
            this.mSourceFileJsonTypeAdapter.write(out, sourceFile);
        }
        if (!(position = src.getPosition()).equals(SourcePosition.UNKNOWN)) {
            out.name(POSITION);
            this.mSourcePositionJsonTypeAdapter.write(out, position);
        }
        out.endObject();
    }

    SourcePositionJsonTypeAdapter getSourcePositionTypeAdapter() {
        return this.mSourcePositionJsonTypeAdapter;
    }
}

