/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFileJsonTypeAdapter;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourceFilePositionJsonSerializer;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.SourcePositionJsonTypeAdapter;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;

public class MessageJsonSerializer
extends TypeAdapter<Message> {
    private static final String KIND = "kind";
    private static final String TEXT = "text";
    private static final String SOURCE_FILE_POSITIONS = "sources";
    private static final String RAW_MESSAGE = "original";
    private static final String TOOL_NAME = "tool";
    private static final String LEGACY_SOURCE_PATH = "sourcePath";
    private static final String LEGACY_POSITION = "position";
    private static final BiMap<Message.Kind, String> KIND_STRING_ENUM_MAP;
    private final SourceFilePositionJsonSerializer mSourceFilePositionTypeAdapter = new SourceFilePositionJsonSerializer();
    private final SourcePositionJsonTypeAdapter mSourcePositionTypeAdapter = this.mSourceFilePositionTypeAdapter.getSourcePositionTypeAdapter();

    @Override
    public void write(JsonWriter out, Message message) throws IOException {
        out.beginObject().name(KIND).value((String)KIND_STRING_ENUM_MAP.get((Object)message.getKind())).name(TEXT).value(message.getText()).name(SOURCE_FILE_POSITIONS).beginArray();
        for (SourceFilePosition position : message.getSourceFilePositions()) {
            this.mSourceFilePositionTypeAdapter.write(out, position);
        }
        out.endArray();
        if (!message.getRawMessage().equals(message.getText())) {
            out.name(RAW_MESSAGE).value(message.getRawMessage());
        }
        if (message.getToolName() != null) {
            out.name(TOOL_NAME).value(message.getToolName());
        }
        out.endObject();
    }

    @Override
    public Message read(JsonReader in) throws IOException {
        ImmutableCollection sourceFilePositions;
        in.beginObject();
        Message.Kind kind = Message.Kind.UNKNOWN;
        String text = "";
        String rawMessage = null;
        String toolName = null;
        ImmutableList.Builder positions = new ImmutableList.Builder();
        SourceFile legacyFile = SourceFile.UNKNOWN;
        SourcePosition legacyPosition = SourcePosition.UNKNOWN;
        block4: while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals(KIND)) {
                Message.Kind theKind = (Message.Kind)((Object)KIND_STRING_ENUM_MAP.inverse().get(in.nextString().toLowerCase()));
                kind = theKind != null ? theKind : Message.Kind.UNKNOWN;
                continue;
            }
            if (name.equals(TEXT)) {
                text = in.nextString();
                continue;
            }
            if (name.equals(RAW_MESSAGE)) {
                rawMessage = in.nextString();
                continue;
            }
            if (name.equals(TOOL_NAME)) {
                toolName = in.nextString();
                continue;
            }
            if (name.equals(SOURCE_FILE_POSITIONS)) {
                switch (in.peek()) {
                    case BEGIN_ARRAY: {
                        in.beginArray();
                        while (in.hasNext()) {
                            positions.add(this.mSourceFilePositionTypeAdapter.read(in));
                        }
                        in.endArray();
                        continue block4;
                    }
                    case BEGIN_OBJECT: {
                        positions.add(this.mSourceFilePositionTypeAdapter.read(in));
                        continue block4;
                    }
                }
                in.skipValue();
                continue;
            }
            if (name.equals(LEGACY_SOURCE_PATH)) {
                legacyFile = new SourceFile(new File(in.nextString()));
                continue;
            }
            if (name.equals(LEGACY_POSITION)) {
                legacyPosition = this.mSourcePositionTypeAdapter.read(in);
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        if (legacyFile != SourceFile.UNKNOWN || legacyPosition != SourcePosition.UNKNOWN) {
            positions.add(new SourceFilePosition(legacyFile, legacyPosition));
        }
        if (rawMessage == null) {
            rawMessage = text;
        }
        if (!(sourceFilePositions = positions.build()).isEmpty()) {
            return new Message(kind, text, rawMessage, toolName, (ImmutableList<SourceFilePosition>)sourceFilePositions);
        }
        return new Message(kind, text, rawMessage, toolName, ImmutableList.of(SourceFilePosition.UNKNOWN));
    }

    public static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter((Type)((Object)SourceFile.class), new SourceFileJsonTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)SourcePosition.class), new SourcePositionJsonTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)SourceFilePosition.class), new SourceFilePositionJsonSerializer());
        builder.registerTypeAdapter((Type)((Object)Message.class), new MessageJsonSerializer());
    }

    static {
        EnumHashBiMap<Message.Kind, String> map2 = EnumHashBiMap.create(Message.Kind.class);
        map2.put(Message.Kind.ERROR, "error");
        map2.put(Message.Kind.WARNING, "warning");
        map2.put(Message.Kind.INFO, "info");
        map2.put(Message.Kind.STATISTICS, "statistics");
        map2.put(Message.Kind.UNKNOWN, "unknown");
        map2.put(Message.Kind.SIMPLE, "simple");
        KIND_STRING_ENUM_MAP = Maps.unmodifiableBiMap(map2);
    }
}

