/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.Log;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;

public class JdwpLoggingUtils {
    public static void log(String owner, String action, JdwpPacket packet) {
        if (Log.isAtLeast(Log.LogLevel.VERBOSE)) {
            Log.v("JdwpProxy-Packet", String.format("%s %s (%d)", owner, action, packet.getId()));
            packet.log(action);
        }
    }

    public static void log(String owner, String action, byte[] buffer, int length) {
        if (Log.isAtLeast(Log.LogLevel.VERBOSE)) {
            Log.v("JdwpProxy-Buffer", String.format("%s %s (%d) %s", owner, action, length, JdwpLoggingUtils.formatBytesToString(buffer, length)));
        }
    }

    private static String formatBytesToString(byte[] buffer, int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (Character.isLetterOrDigit((char)buffer[i2])) {
                builder.append((char)buffer[i2]);
                continue;
            }
            builder.append(Integer.toHexString(buffer[i2]));
        }
        return builder.toString();
    }
}

