/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerId;
import com.android.ddmlib.internal.jdwp.JdwpLoggingUtils;
import com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import com.android.ddmlib.internal.jdwp.JdwpSocketHandler;
import com.android.ddmlib.internal.jdwp.chunkhandler.BadPacketException;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.internal.jdwp.interceptor.ClientInitializationInterceptor;
import com.android.ddmlib.internal.jdwp.interceptor.DebuggerInterceptor;
import com.android.ddmlib.internal.jdwp.interceptor.HandshakeInterceptor;
import com.android.ddmlib.internal.jdwp.interceptor.Interceptor;
import com.android.ddmlib.internal.jdwp.interceptor.NoReplyPacketInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JdwpClientManager
implements JdwpSocketHandler {
    private SocketChannel mAdbSocket;
    private final Set<JdwpProxyClient> mClients = new HashSet<JdwpProxyClient>();
    private final List<Interceptor> mInterceptors = new ArrayList<Interceptor>();
    private final List<ShutdownListener> mShutdownListeners = new ArrayList<ShutdownListener>();
    private final byte[] mBuffer;
    private final byte[] mSendBuffer = new byte[0x100000];

    public JdwpClientManager(JdwpClientManagerId id, Selector selector, byte[] readBuffer) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.mBuffer = readBuffer;
        this.mAdbSocket = AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), id.deviceSerial, id.pid);
        this.mAdbSocket.configureBlocking(false);
        this.mAdbSocket.register(selector, 1, this);
        this.mInterceptors.add(new NoReplyPacketInterceptor());
        this.mInterceptors.add(new HandshakeInterceptor());
        this.mInterceptors.add(new ClientInitializationInterceptor());
        this.mInterceptors.add(new DebuggerInterceptor());
    }

    void addListener(JdwpProxyClient client) {
        this.mClients.add(client);
    }

    void removeListener(JdwpProxyClient client) {
        this.mClients.remove(client);
    }

    void addShutdownListener(ShutdownListener listener) {
        this.mShutdownListeners.add(listener);
    }

    @VisibleForTesting
    void addInterceptor(Interceptor interceptor) {
        this.mInterceptors.add(interceptor);
    }

    @Override
    public void shutdown() throws IOException {
        for (ShutdownListener listener : this.mShutdownListeners) {
            listener.shutdown();
        }
        this.mShutdownListeners.clear();
        while (!this.mClients.isEmpty()) {
            JdwpProxyClient client = this.mClients.iterator().next();
            client.shutdown();
            if (!this.mClients.contains(client)) continue;
            this.mClients.remove(client);
        }
        if (this.mAdbSocket != null) {
            this.mAdbSocket.close();
            this.mAdbSocket = null;
        }
    }

    @Override
    public void read() throws IOException, TimeoutException {
        if (this.mAdbSocket == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.mBuffer);
        int length = this.mAdbSocket.read(buffer);
        if (length == -1) {
            this.shutdown();
            throw new EOFException("Client disconnected");
        }
        JdwpLoggingUtils.log("DEVICE", "READ", this.mBuffer, length);
        boolean isJdwpPacket = true;
        for (JdwpProxyClient client : this.mClients) {
            if (this.filterToClient(client, this.mBuffer, length)) continue;
            try {
                JdwpPacket packet;
                buffer = ByteBuffer.wrap(this.mBuffer, 0, length);
                buffer.position(length);
                if (isJdwpPacket && length >= 11 && (packet = JdwpPacket.findPacket(buffer)) != null) {
                    ByteBuffer sendBuffer = ByteBuffer.wrap(this.mSendBuffer);
                    do {
                        if (!this.filterToClient(client, packet)) {
                            packet.move(sendBuffer);
                        }
                        packet.consume();
                    } while ((packet = JdwpPacket.findPacket(buffer)) != null);
                    if (buffer.position() != 0) {
                        isJdwpPacket = false;
                    } else if (sendBuffer.position() != 0) {
                        client.write(this.mSendBuffer, sendBuffer.position());
                    }
                } else {
                    isJdwpPacket = false;
                }
            }
            catch (BadPacketException ex) {
                isJdwpPacket = false;
            }
            if (isJdwpPacket) continue;
            client.write(this.mBuffer, length);
        }
    }

    void write(JdwpProxyClient from, byte[] value, int length) throws IOException, TimeoutException {
        boolean isJdwpPacket;
        if (this.mAdbSocket == null || this.filterToDevice(from, value, length)) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(value, 0, length);
        buffer.position(length);
        ByteBuffer sendBuffer = ByteBuffer.wrap(this.mSendBuffer);
        try {
            JdwpPacket packet = JdwpPacket.findPacket(buffer);
            if (packet != null) {
                isJdwpPacket = true;
                do {
                    if (!this.filterToDevice(from, packet)) {
                        packet.move(sendBuffer);
                    }
                    packet.consume();
                } while ((packet = JdwpPacket.findPacket(buffer)) != null);
            } else {
                isJdwpPacket = false;
            }
        }
        catch (BadPacketException ex) {
            isJdwpPacket = false;
        }
        if (!isJdwpPacket) {
            sendBuffer.put(value, 0, length);
        }
        if (sendBuffer.position() != 0) {
            this.writeRaw(sendBuffer);
        }
    }

    @VisibleForTesting
    void writeRaw(ByteBuffer sendBuffer) throws IOException, TimeoutException {
        JdwpLoggingUtils.log("DEVICE", "WRITE", sendBuffer.array(), sendBuffer.position());
        AdbHelper.write(this.mAdbSocket, sendBuffer.array(), sendBuffer.position(), DdmPreferences.getTimeOut());
    }

    private boolean filterToDevice(JdwpProxyClient client, JdwpPacket packet) throws IOException, TimeoutException {
        boolean filter2 = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter2 |= interceptor.filterToDevice(client, packet);
        }
        return filter2;
    }

    private boolean filterToDevice(JdwpProxyClient client, byte[] value, int length) throws IOException, TimeoutException {
        boolean filter2 = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter2 |= interceptor.filterToDevice(client, value, length);
        }
        return filter2;
    }

    private boolean filterToClient(JdwpProxyClient client, JdwpPacket packet) throws IOException, TimeoutException {
        boolean filter2 = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter2 |= interceptor.filterToClient(client, packet);
        }
        return filter2;
    }

    private boolean filterToClient(JdwpProxyClient client, byte[] value, int length) throws IOException, TimeoutException {
        boolean filter2 = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter2 |= interceptor.filterToClient(client, value, length);
        }
        return filter2;
    }

    static interface ShutdownListener {
        public void shutdown();
    }
}

