/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ByteBufferUtil;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DebugViewDumpHandler
extends ChunkHandler {
    public static final int CHUNK_VUGL = DebugViewDumpHandler.type("VUGL");
    public static final int CHUNK_VULW = DebugViewDumpHandler.type("VULW");
    public static final int CHUNK_VURT = DebugViewDumpHandler.type("VURT");
    public static final int CHUNK_VUOP = DebugViewDumpHandler.type("VUOP");
    private final CountDownLatch mLatch = new CountDownLatch(1);
    private final int mChunkType;

    public DebugViewDumpHandler(int chunkType) {
        this.mChunkType = chunkType;
    }

    @Override
    public void clientReady(ClientImpl client) throws IOException {
    }

    @Override
    public void clientDisconnected(ClientImpl client) {
    }

    @Override
    public void handleChunk(ClientImpl client, int type2, ByteBuffer data2, boolean isReply, int msgId) {
        if (type2 != this.mChunkType) {
            this.handleUnknownChunk(client, type2, data2, isReply, msgId);
            return;
        }
        this.handleViewDebugResult(data2);
        this.mLatch.countDown();
    }

    protected abstract void handleViewDebugResult(ByteBuffer var1);

    protected void waitForResult(long timeout, TimeUnit unit) {
        try {
            this.mLatch.await(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getString(ByteBuffer buf, int len) {
        return ByteBufferUtil.getString(buf, len);
    }
}

