/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trafficrule.migrate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mongodb.client.result.UpdateResult;
import com.ubnt.data.NetworkConf;
import com.ubnt.service.system.bA;
import com.ubnt.service.system.db.migrator.oOOO;
import com.ubnt.service.traffic.TrafficTargetDeviceDocumentPart;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@oOOO
class A {
    private static final Logger super = bA.\u00d200000;
    private final MongoTemplate \u00d200000;

    A(MongoTemplate mongoTemplate) {
        this.\u00d200000 = mongoTemplate;
    }

    boolean \u00f400000(String string) {
        Criteria criteria = Criteria.where((String)"site_id").is((Object)string);
        return this.\u00d200000.exists(new Query((CriteriaDefinition)criteria), TrafficRuleDocument.class);
    }

    void classsuper() {
        this.\u00d200000.updateMulti(new Query((CriteriaDefinition)new Criteria("domains").exists(false)), (UpdateDefinition)new Update().set("domains", Collections.emptyList()), "traffic_rule");
    }

    void public() {
        this.\u00d200000.updateMulti(new Query((CriteriaDefinition)new Criteria("regions").exists(false)), (UpdateDefinition)new Update().set("regions", Collections.emptyList()), TrafficRuleDocument.class);
    }

    void \u00f4O0000() {
        this.\u00d200000.updateMulti(new Query((CriteriaDefinition)new Criteria("bandwidth_limit").exists(false)), (UpdateDefinition)new Update().set("bandwidth_limit", (Object)ImmutableMap.of((Object)"enabled", (Object)false, (Object)"download_limit_kbps", (Object)1024L, (Object)"upload_limit_kbps", (Object)1024L)), TrafficRuleDocument.class);
    }

    void o00000() {
        this.\u00d200000.updateMulti(new Query((CriteriaDefinition)new Criteria("bandwidth_limit").exists(true)), (UpdateDefinition)new Update().set("bandwidth_limit", (Object)ImmutableMap.of((Object)"enabled", (Object)false, (Object)"download_limit_kbps", (Object)1024, (Object)"upload_limit_kbps", (Object)1024)), TrafficRuleDocument.class);
    }

    List<TrafficRuleDocument> \u00d600000(String string) {
        Criteria criteria = Criteria.where((String)"site_id").is((Object)string);
        return this.\u00d200000.find(Query.query((CriteriaDefinition)criteria), TrafficRuleDocument.class);
    }

    Set<String> void(List<TrafficRuleDocument> list, List<NetworkConf> list2) {
        Set set = list2.stream().map(NetworkConf::getId).collect(Collectors.toSet());
        Set set2 = list.stream().map(this::\u00d200000).flatMap(Collection::stream).collect(Collectors.toSet());
        return Sets.difference(set2, set);
    }

    void \u00f500000(List<TrafficRuleDocument> list, String string) {
        list.forEach(trafficRuleDocument -> this.\u00f6O0000((TrafficRuleDocument)trafficRuleDocument, string));
    }

    public long supersuper(String string) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("enabled").is((Object)true).and("schedule").exists(true).and("schedule.mode").is((Object)"CUSTOM").and("schedule.date_start").exists(false));
        Update update = new Update().set("enabled", (Object)false);
        UpdateResult updateResult = this.\u00d200000.updateMulti(query, (UpdateDefinition)update, TrafficRuleDocument.class);
        return updateResult.getModifiedCount();
    }

    public long \u00f5O0000(String string, List<String> list) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("enabled").is((Object)true).and("id").in(list));
        Update update = new Update().set("enabled", (Object)false);
        UpdateResult updateResult = this.\u00d200000.updateMulti(query, (UpdateDefinition)update, TrafficRuleDocument.class);
        return updateResult.getModifiedCount();
    }

    private void \u00f6O0000(TrafficRuleDocument trafficRuleDocument, String string) {
        List<String> list;
        List<TrafficTargetDeviceDocumentPart> list2 = this.\u00d400000(trafficRuleDocument, string);
        if (this.oO0000(trafficRuleDocument, list2, list = this.float(trafficRuleDocument, string))) {
            TrafficRuleDocument trafficRuleDocument2 = TrafficRuleDocument.from(trafficRuleDocument, this.\u00d6O0000(trafficRuleDocument, list2, list), list2, list);
            this.\u00d200000.save((Object)trafficRuleDocument2);
        }
    }

    private List<TrafficTargetDeviceDocumentPart> \u00d400000(TrafficRuleDocument trafficRuleDocument, String string) {
        return trafficRuleDocument.getTargetDevices().stream().filter(trafficTargetDeviceDocumentPart -> !StringUtils.equals((CharSequence)string, (CharSequence)trafficTargetDeviceDocumentPart.getNetworkId())).collect(Collectors.toList());
    }

    private List<String> float(TrafficRuleDocument trafficRuleDocument, String string) {
        return trafficRuleDocument.getNetworkIds().stream().filter(string2 -> !StringUtils.equals((CharSequence)string2, (CharSequence)string)).collect(Collectors.toList());
    }

    private boolean oO0000(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list, List<String> list2) {
        return list2.size() != trafficRuleDocument.getNetworkIds().size() || list.size() != trafficRuleDocument.getTargetDevices().size();
    }

    private boolean \u00d6O0000(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list, List<String> list2) {
        return trafficRuleDocument.isEnabled() && !this.\u00d5O0000(trafficRuleDocument, list2) && !this.\u00d4O0000(trafficRuleDocument, list);
    }

    private boolean \u00d5O0000(TrafficRuleDocument trafficRuleDocument, List<String> list) {
        return !trafficRuleDocument.getNetworkIds().isEmpty() && list.isEmpty();
    }

    private boolean \u00d4O0000(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list) {
        return !trafficRuleDocument.getTargetDevices().isEmpty() && list.isEmpty();
    }

    private Set<String> \u00d200000(TrafficRuleDocument trafficRuleDocument) {
        Set set = trafficRuleDocument.getTargetDevices().stream().map(TrafficTargetDeviceDocumentPart::getNetworkId).filter(Objects::nonNull).collect(Collectors.toSet());
        return ImmutableSet.builder().addAll(set).addAll(trafficRuleDocument.getNetworkIds()).build();
    }

    void \u00d500000(String string, TrafficRuleDocument trafficRuleDocument) {
        super.info("Removing obsolete Traffic Rule {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        this.\u00d200000.remove(query, TrafficRuleDocument.class);
    }

    public void \u00f600000(String string, TrafficRuleDocument trafficRuleDocument) {
        super.info("Removing obsolete Applications and Categories from Traffic Rule {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        Update update = new Update().set("app_category_ids", trafficRuleDocument.getAppCategoryIds()).set("app_ids", trafficRuleDocument.getAppIds());
        this.\u00d200000.updateFirst(query, (UpdateDefinition)update, TrafficRuleDocument.class);
    }
}

