/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api;

import com.ubnt.data.Site;
import com.ubnt.service.system.ifObject;
import com.ubnt.service.trace.M;
import com.ubnt.service.trace.api.DeviceEvent;
import com.ubnt.service.trace.api.Trace;
import com.ubnt.service.trace.api.UUSCommitErrorEvent;
import com.ubnt.service.trace.model.common.TraceMeta;

public class TraceEventManager {
    private static final String TRACE_CONTROLLER_DEVICE_NAMESPACE = "unifi:network:controller:device";
    private static final String TRACE_UUS_ERROR_EVENT_NAMESPACE = "ubios:udapi-server";
    private final M tracer;
    private final ifObject siteManager;

    public TraceEventManager(M m2, ifObject ifObject2) {
        this.tracer = m2;
        this.siteManager = ifObject2;
    }

    public void sendDeviceEvent(DeviceEvent deviceEvent) {
        Site site = this.siteManager.\u00f6O\u00d5000(deviceEvent.getDevice().getSiteId());
        TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
        Trace trace = new Trace().setNamespace(TRACE_CONTROLLER_DEVICE_NAMESPACE).setMeta(traceMeta).setType(deviceEvent.getType()).setPayloadData(deviceEvent);
        this.tracer.\u00d200000(trace);
    }

    public void sendUUSCommitErrorEvent(UUSCommitErrorEvent uUSCommitErrorEvent) {
        Site site = this.siteManager.\u00f6O\u00d5000(uUSCommitErrorEvent.getDevice().getSiteId());
        TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
        Trace trace = new Trace().setNamespace(TRACE_UUS_ERROR_EVENT_NAMESPACE).setMeta(traceMeta).setType(uUSCommitErrorEvent.getType()).setPayloadData(uUSCommitErrorEvent);
        this.tracer.\u00d200000(trace);
    }
}

