/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.blebridge.ucp4.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.service.blebridge.ucp4.model.BleUcp4VersionInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="BleUcp4VersionInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableBleUcp4VersionInfo
implements BleUcp4VersionInfo {
    private final String apiVersion;
    private final String firmwareVersion;
    @Nullable
    private final String anonymousId;

    private ImmutableBleUcp4VersionInfo(String string, String string2, @Nullable String string3) {
        this.apiVersion = string;
        this.firmwareVersion = string2;
        this.anonymousId = string3;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="fwv")
    public String firmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    @JsonProperty(value="annoid")
    public Optional<String> anonymousId() {
        return Optional.ofNullable(this.anonymousId);
    }

    public final ImmutableBleUcp4VersionInfo withApiVersion(String string) {
        String string2 = Objects.requireNonNull(string, "apiVersion");
        if (this.apiVersion.equals(string2)) {
            return this;
        }
        return new ImmutableBleUcp4VersionInfo(string2, this.firmwareVersion, this.anonymousId);
    }

    public final ImmutableBleUcp4VersionInfo withFirmwareVersion(String string) {
        String string2 = Objects.requireNonNull(string, "firmwareVersion");
        if (this.firmwareVersion.equals(string2)) {
            return this;
        }
        return new ImmutableBleUcp4VersionInfo(this.apiVersion, string2, this.anonymousId);
    }

    public final ImmutableBleUcp4VersionInfo withAnonymousId(@Nullable String string) {
        String string2 = string;
        if (Objects.equals(this.anonymousId, string2)) {
            return this;
        }
        return new ImmutableBleUcp4VersionInfo(this.apiVersion, this.firmwareVersion, string2);
    }

    public final ImmutableBleUcp4VersionInfo withAnonymousId(Optional<String> optional) {
        String string = optional.orElse(null);
        if (Objects.equals(this.anonymousId, string)) {
            return this;
        }
        return new ImmutableBleUcp4VersionInfo(this.apiVersion, this.firmwareVersion, string);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableBleUcp4VersionInfo && this.super(0, (ImmutableBleUcp4VersionInfo)object);
    }

    private boolean super(int n2, ImmutableBleUcp4VersionInfo immutableBleUcp4VersionInfo) {
        return this.apiVersion.equals(immutableBleUcp4VersionInfo.apiVersion) && this.firmwareVersion.equals(immutableBleUcp4VersionInfo.firmwareVersion) && Objects.equals(this.anonymousId, immutableBleUcp4VersionInfo.anonymousId);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.apiVersion.hashCode();
        n2 += (n2 << 5) + this.firmwareVersion.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.anonymousId);
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BleUcp4VersionInfo").omitNullValues().add("apiVersion", (Object)this.apiVersion).add("firmwareVersion", (Object)this.firmwareVersion).add("anonymousId", (Object)this.anonymousId).toString();
    }

    public static ImmutableBleUcp4VersionInfo copyOf(BleUcp4VersionInfo bleUcp4VersionInfo) {
        if (bleUcp4VersionInfo instanceof ImmutableBleUcp4VersionInfo) {
            return (ImmutableBleUcp4VersionInfo)bleUcp4VersionInfo;
        }
        return ImmutableBleUcp4VersionInfo.builder().from(bleUcp4VersionInfo).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="BleUcp4VersionInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_API_VERSION = 1L;
        private static final long INIT_BIT_FIRMWARE_VERSION = 2L;
        private long initBits = 3L;
        @Nullable
        private String apiVersion;
        @Nullable
        private String firmwareVersion;
        @Nullable
        private String anonymousId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BleUcp4VersionInfo bleUcp4VersionInfo) {
            Objects.requireNonNull(bleUcp4VersionInfo, "instance");
            this.apiVersion(bleUcp4VersionInfo.apiVersion());
            this.firmwareVersion(bleUcp4VersionInfo.firmwareVersion());
            Optional<String> optional = bleUcp4VersionInfo.anonymousId();
            if (optional.isPresent()) {
                this.anonymousId(optional);
            }
            return this;
        }

        @JsonProperty(value="apiVersion")
        @CanIgnoreReturnValue
        public final Builder apiVersion(String string) {
            this.apiVersion = Objects.requireNonNull(string, "apiVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fwv")
        @CanIgnoreReturnValue
        public final Builder firmwareVersion(String string) {
            this.firmwareVersion = Objects.requireNonNull(string, "firmwareVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder anonymousId(@Nullable String string) {
            this.anonymousId = string;
            return this;
        }

        @JsonProperty(value="annoid")
        @CanIgnoreReturnValue
        public final Builder anonymousId(Optional<String> optional) {
            this.anonymousId = optional.orElse(null);
            return this;
        }

        public ImmutableBleUcp4VersionInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.o00000());
            }
            return new ImmutableBleUcp4VersionInfo(this.apiVersion, this.firmwareVersion, this.anonymousId);
        }

        private String o00000() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("apiVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                arrayList.add("firmwareVersion");
            }
            return "Cannot build BleUcp4VersionInfo, some of required attributes are not set " + arrayList;
        }
    }
}

