/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.wireless;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VapSettings {
    private Boolean no2ghzOui;
    private Boolean broadcastFilter;
    private Boolean ieee80211k;
    private Boolean fastTransition;
    private Integer dtimPeriod;
    private Boolean pureg;
    private Boolean hideSsid;
    private String security;
    private Boolean multicastEnhance;
    private Boolean schedule;
    private Boolean pmf;
    private Integer pmfMode;
    private Boolean l2Isolation;
    private Long minrateData;
    private Boolean sharedSsid;
    private String usage;

    public VapSettings(X x2, X x3) {
        this.no2ghzOui = x2.getBoolean("no2ghz_oui");
        this.broadcastFilter = x2.getX("bcfilt", X.\u00d3\u00d30000).getBoolean("status");
        this.ieee80211k = x3.getX("11k", X.\u00d3\u00d30000).getBoolean("status");
        this.fastTransition = x3.getX("ft", X.\u00d3\u00d30000).getBoolean("status");
        this.dtimPeriod = x2.getInt("dtim_period");
        this.pureg = x2.getBoolean("pureg");
        this.hideSsid = x2.getBoolean("hide_ssid");
        List<X> list = x3.getX("wpa", X.\u00d3\u00d30000).getX("key", X.\u00d3\u00d30000).getList("__array__", X.\u00d3o0000);
        this.security = list.size() > 0 ? list.get(0).getString("mgmt") : (x3.getString("security", "").startsWith("wep") ? "WEP" : "OPEN");
        this.multicastEnhance = x2.getX("mcast", X.\u00d3\u00d30000).getBoolean("enhance");
        this.schedule = x2.getBoolean("schedule_enabled");
        this.pmf = x3.getX("pmf", X.\u00d3\u00d30000).getBoolean("status");
        this.pmfMode = x3.getX("pmf", X.\u00d3\u00d30000).getInt("mode");
        this.l2Isolation = x2.getBoolean("l2_isolation");
        this.minrateData = x2.getLong("minrate_data");
        this.usage = x2.getString("usage", "unknown");
    }

    public Boolean getNo2ghzOui() {
        return this.no2ghzOui;
    }

    public Boolean getBroadcastFilter() {
        return this.broadcastFilter;
    }

    public Boolean getIeee80211k() {
        return this.ieee80211k;
    }

    public Boolean getFastTransition() {
        return this.fastTransition;
    }

    public Integer getDtimPeriod() {
        return this.dtimPeriod;
    }

    public Boolean getPureg() {
        return this.pureg;
    }

    public Boolean getHideSsid() {
        return this.hideSsid;
    }

    public String getSecurity() {
        return this.security;
    }

    public Boolean getMulticastEnhance() {
        return this.multicastEnhance;
    }

    public Boolean getSchedule() {
        return this.schedule;
    }

    public Boolean getPmf() {
        return this.pmf;
    }

    public Integer getPmfMode() {
        return this.pmfMode;
    }

    public Boolean getL2Isolation() {
        return this.l2Isolation;
    }

    public Long getMinrateData() {
        return this.minrateData;
    }

    public Boolean getSharedSsid() {
        return this.sharedSsid;
    }

    public VapSettings setSharedSsid(boolean bl) {
        this.sharedSsid = bl;
        return this;
    }

    public String getUsage() {
        return this.usage;
    }
}

