/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifiman;

import com.ubnt.data.Site;
import com.ubnt.model.api.report.IncorrectWifiExperience;
import com.ubnt.model.api.wifiman.WifiManClientInfo;
import com.ubnt.model.api.wifiman.WifiManDevice;
import com.ubnt.model.api.wifiman.WifiManFeedback;
import com.ubnt.model.api.wifiman.WifiManFeedbackRequest;
import com.ubnt.model.api.wifiman.WifiManFeedbackResponse;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowApiToken;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.service.wifiman.B;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Api(tags={"WiFiman"})
public class WifiManController {
    private final B o00000;

    public WifiManController(B b2) {
        this.o00000 = b2;
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman"})
    @ApiOperation(value="Get WiFiman Feedback")
    public List<WifiManFeedback> getFeedbackList(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d300000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/devices"})
    @ApiOperation(value="Get list of connected devices and clients")
    @AllowApiToken
    public List<WifiManDevice> getDevices(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string) {
        return this.o00000.class(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman/{clientIp}"})
    @ApiOperation(value="Get WiFiman Client Info")
    @AllowApiToken
    public WifiManClientInfo getClientInfo(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string) {
        return this.o00000.\u00d200000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/feedback"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Send WiFiman Speed Test Feedback")
    @AllowApiToken
    public WifiManFeedbackResponse sendFeedback(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string, @Valid @NotNull @RequestBody WifiManFeedbackRequest wifiManFeedbackRequest) {
        return this.o00000.\u00d600000(site.getId(), string, wifiManFeedbackRequest);
    }

    @PutMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/feedback/{feedbackId}/wifi_experience"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Report Incorrect WiFi Experience")
    @AllowApiToken
    public void reportIncorrectWifiExperience(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string, @PathVariable(value="feedbackId") String string2, @RequestBody IncorrectWifiExperience incorrectWifiExperience) {
        this.o00000.\u00d800000(site.getId(), string, string2, incorrectWifiExperience);
    }
}

