/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifi;

import com.ubnt.data.Site;
import com.ubnt.model.api.wifi.ap.WifiApStatisticsDto;
import com.ubnt.model.api.wifi.client.WifiClientStatisticsDto;
import com.ubnt.model.api.wifi.radio.WifiRadioStatisticsDto;
import com.ubnt.model.class.B;
import com.ubnt.net.v2.ApiFilterUtils;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.wifi.C.J;
import com.ubnt.service.wifi.C.OOoO;
import com.ubnt.service.wifi.C.OoOO;
import com.ubnt.service.wifi.C.super;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Clock;
import java.util.Optional;
import javax.validation.constraints.Min;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Api(tags={"WiFi Statistics"})
public class WifiStatisticsController {
    static final String \u00d300000 = "7.1.5";
    static final String o00000 = "7.3.11";
    private final Clock new;
    private final OoOO return;
    private final OOoO \u00d400000;
    private final super \u00d500000;

    public WifiStatisticsController(Clock clock, OoOO ooOO2, OOoO oOoO2, super super_) {
        this.new = clock;
        this.return = ooOO2;
        this.\u00d400000 = oOoO2;
        this.\u00d500000 = super_;
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/details"})
    @ApiOperation(value="WiFi Client statistics", notes="Since 7.1")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiClientStatisticsDto wifiClientStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @ApiParam(value="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @ApiParam(value="Filter end in unix epoch seconds") Long l3, @RequestParam(value="apMac", required=false) @MacAddress(allowAll=true) @MacAddress(allowAll=true) String string, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @ApiParam(value="Size of top user list returned") @Min(value=1L) Integer n2) {
        J j2 = J.\u00f400000().\u00d800000(site.getId()).\u00d300000(B.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.new, l3))).\u00d500000(ApiFilterUtils.getMacFilter(string)).\u00d200000(Optional.ofNullable(n2)).\u00f500000(\u00d300000).null();
        return WifiClientStatisticsDto.builder().clientDetails(this.return.\u00d400000(j2)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/aps"})
    @ApiOperation(value="WiFi Access Point statistics", notes="Since 7.3")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiApStatisticsDto wifiApStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @ApiParam(value="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @ApiParam(value="Filter end in unix epoch seconds") Long l3, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @ApiParam(value="Size of top APs list returned") @Min(value=1L) Integer n2) {
        J j2 = J.\u00f400000().\u00d800000(site.getId()).\u00d300000(B.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.new, l3))).\u00d200000(Optional.ofNullable(n2)).\u00f500000(o00000).null();
        return WifiApStatisticsDto.builder().apDetails(this.\u00d400000.\u00d600000(j2)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/radios"})
    @ApiOperation(value="WiFi Radio statistics", notes="Since 7.6.24")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiRadioStatisticsDto wifiRadioStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @ApiParam(value="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @ApiParam(value="Filter end in unix epoch seconds") Long l3) {
        J j2 = J.\u00f400000().\u00d800000(site.getId()).\u00d300000(B.\u00d500000(l2, ApiFilterUtils.getEndTimestamp(this.new, l3))).\u00f500000(o00000).null();
        return WifiRadioStatisticsDto.builder().radioDetails(this.\u00d500000.\u00f500000(j2)).build();
    }
}

