/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wan;

import com.ubnt.data.Site;
import com.ubnt.model.api.wan.loadbalancing.WanLoadBalancingConfigurationDto;
import com.ubnt.model.api.wan.loadbalancing.WanLoadBalancingStatusDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.wan.loadbalancing.C;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@V2RestController
@Validated
@Api(tags={"WAN Load Balancing"})
public class WanLoadBalancingController {
    private final C o00000;

    public WanLoadBalancingController(C c2) {
        this.o00000 = c2;
    }

    @ApiOperation(value="Get WAN load balancing configuration", notes="Since 7.1.36")
    @GetMapping(value={"/api/site/{siteName}/wan/load-balancing/configuration"})
    public WanLoadBalancingConfigurationDto getWanLoadBalancingConfiguration(@PathVariable(value="siteName") Site site) {
        return WanLoadBalancingConfigurationDto.of(this.o00000.\u00d400000(site.getId()));
    }

    @ApiOperation(value="Update WAN load balancing configuration", notes="Since 7.1.36")
    @PutMapping(value={"/api/site/{siteName}/wan/load-balancing/configuration"})
    public WanLoadBalancingConfigurationDto updateWanLoadBalancingConfiguration(@PathVariable(value="siteName") Site site, @Valid @RequestBody WanLoadBalancingConfigurationDto wanLoadBalancingConfigurationDto) {
        return WanLoadBalancingConfigurationDto.of(this.o00000.\u00f500000(wanLoadBalancingConfigurationDto.toWanLoadBalancingConfiguration(site.getId())));
    }

    @ApiOperation(value="Get WAN load balancing status", notes="Since 7.1.36")
    @GetMapping(value={"/api/site/{siteName}/wan/load-balancing/status"})
    public WanLoadBalancingStatusDto getWanLoadBalancingStatus(@PathVariable(value="siteName") Site site) {
        return WanLoadBalancingStatusDto.of(this.o00000.oO0000(site.getId()));
    }
}

