/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.vpn;

import com.ubnt.data.Site;
import com.ubnt.model.api.vpn.WireguardUserDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.vpn.H;
import com.ubnt.service.vpn.WireguardUserDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Api(tags={"Wireguard VPN"})
public class WireguardController {
    private final H o00000;

    public WireguardController(H h2) {
        this.o00000 = h2;
    }

    @GetMapping(value={"/api/site/{siteName}/wireguard/{networkId}/users"})
    @AllowUCoreLocal
    @ApiOperation(value="List Wireguard users")
    public List<WireguardUserDto> listWireguardUsers(@PathVariable(value="siteName") Site site, @PathVariable(value="networkId") String string) {
        return this.o00000.thissuper(site.getId(), string).stream().map(WireguardUserDto::fromDocument).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/site/{siteName}/wireguard/{networkId}/users/batch"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Batch create Wireguard users")
    public List<WireguardUserDto> batchCreateUsers(@PathVariable(value="siteName") Site site, @PathVariable(value="networkId") String string, @RequestBody @Valid @NotEmpty List<WireguardUserDto> list) {
        String string2 = site.getId();
        List<WireguardUserDocument> list2 = list.stream().map(wireguardUserDto -> wireguardUserDto.withEmptyId().toDocument(string2, string)).toList();
        return this.o00000.oO0000(string2, string, list2).stream().map(WireguardUserDto::fromDocument).toList();
    }

    @PutMapping(value={"/api/site/{siteName}/wireguard/{networkId}/users/batch"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Batch update Wireguard users")
    public List<WireguardUserDto> batchUpdateUsers(@PathVariable(value="siteName") Site site, @PathVariable(value="networkId") String string, @RequestBody @Valid @NotEmpty List<WireguardUserDto> list) {
        List<WireguardUserDocument> list2 = list.stream().map(wireguardUserDto -> wireguardUserDto.toDocument(site.getId(), string)).collect(Collectors.toList());
        return this.o00000.if(site.getId(), string, list2).stream().map(WireguardUserDto::fromDocument).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/site/{siteName}/wireguard/{networkId}/users/batch_delete"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Batch remove Wireguard users")
    public void batchDeleteUsers(@PathVariable(value="siteName") Site site, @PathVariable(value="networkId") String string, @RequestBody @NotEmpty List<String> list) {
        this.o00000.\u00f500000(site.getId(), string, list);
    }
}

