/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficstats;

import com.ubnt.data.Site;
import com.ubnt.model.api.trafficstats.CountryTrafficStatsDto;
import com.ubnt.model.api.trafficstats.HistoricalDpiQueryParameters;
import com.ubnt.model.api.trafficstats.HistoricalTrafficUsageDto;
import com.ubnt.model.api.trafficstats.TrafficClientStatsDto;
import com.ubnt.model.api.trafficstats.TrafficTotalUsageStatsDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.stat.dpi.intsuper;
import com.ubnt.service.stat.dpi.ooOO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Api(tags={"Traffic Overview"})
public class TrafficOverviewController {
    private final ooOO o00000;

    public TrafficOverviewController(ooOO ooOO2) {
        this.o00000 = ooOO2;
    }

    @GetMapping(value={"/api/site/{siteName}/traffic"})
    @ApiOperation(value="Get traffic stats")
    public TrafficTotalUsageStatsDto getSiteTraffic(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return TrafficTotalUsageStatsDto.of(this.o00000.\u00f800000(intsuper.if(site.getId(), l2, l3, bl)));
    }

    @GetMapping(value={"/api/site/{siteName}/traffic/{mac}"})
    @ApiOperation(value="Get traffic stats for a specific client")
    public TrafficClientStatsDto getSiteTrafficByMac(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3) {
        return TrafficClientStatsDto.of(this.o00000.\u00f800000(intsuper.new().super(site.getId()).class(l2).\u00d800000(l3).\u00d300000(string).OO0000(false).int()));
    }

    @GetMapping(value={"/api/site/{siteName}/country-traffic"})
    @ApiOperation(value="Get site country traffic usage")
    public CountryTrafficStatsDto getSiteCountryTrafficUsage(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3) {
        return this.o00000.newsuper(site.getId(), l2, l3);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-rate"})
    @ApiOperation(value="Get historical traffic usage", notes="Since 7.1.55")
    public List<HistoricalTrafficUsageDto> getHistoricalSiteTrafficUsage(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return this.o00000.\u00d2\u00d30000(site.getId(), l2, l3, bl, HistoricalDpiQueryParameters.withoutApps());
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/app-traffic-rate"})
    @ApiOperation(value="Get historical traffic usage", notes="Since 7.1.55")
    public List<HistoricalTrafficUsageDto> getHistoricalSiteTrafficUsageByApps(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3, @RequestBody HistoricalDpiQueryParameters historicalDpiQueryParameters, @RequestParam(value="includeUnidentified", defaultValue="false") boolean bl) {
        return this.o00000.\u00d2\u00d30000(site.getId(), l2, l3, bl, historicalDpiQueryParameters);
    }
}

