/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficrule;

import com.ubnt.data.Site;
import com.ubnt.model.api.trafficrule.TrafficRuleDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.trafficrule.J;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Api(tags={"Traffic Rules"})
public class TrafficRuleController {
    private final J o00000;

    public TrafficRuleController(J j2) {
        this.o00000 = j2;
    }

    @GetMapping(value={"/api/site/{siteName}/trafficrules"})
    @ApiOperation(value="List Traffic Rules")
    public List<TrafficRuleDto> listTrafficRules(@PathVariable(value="siteName") Site site) {
        return this.o00000.String(site.getId()).stream().map(TrafficRuleDto::fromDocument).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/site/{siteName}/trafficrules"}, consumes={"application/json"})
    @ApiOperation(value="Create a new Traffic Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public TrafficRuleDto createTrafficRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull TrafficRuleDto trafficRuleDto) {
        TrafficRuleDocument trafficRuleDocument = this.o00000.\u00d200000(trafficRuleDto.toDocument(site.getId()));
        return TrafficRuleDto.fromDocument(trafficRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/trafficrules/{ruleId}"}, consumes={"application/json"})
    @ApiOperation(value="Update Traffic Rule")
    public TrafficRuleDto updateTrafficRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull TrafficRuleDto trafficRuleDto) {
        TrafficRuleDto trafficRuleDto2 = TrafficRuleDto.withId(trafficRuleDto, string);
        TrafficRuleDocument trafficRuleDocument = this.o00000.o00000(trafficRuleDto2.toDocument(site.getId()));
        return TrafficRuleDto.fromDocument(trafficRuleDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/trafficrules/{ruleId}"})
    @ApiOperation(value="Delete Traffic Rule")
    public void deleteTrafficRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.o00000.\u00d500000(site.getId(), string);
    }
}

