/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.teleport;

import com.ubnt.data.Site;
import com.ubnt.model.api.teleport.ImmutableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.ModifiableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.TeleportAccessRequestDto;
import com.ubnt.model.api.teleport.TeleportAccessResponseDto;
import com.ubnt.model.api.teleport.TeleportInvitationDto;
import com.ubnt.model.api.teleport.TeleportInvitationListDto;
import com.ubnt.model.api.teleport.TeleportTokenDto;
import com.ubnt.model.api.teleport.TeleportTokenListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.config.security.annotation.RequireConsoleOwner;
import com.ubnt.net.v2.config.security.annotation.RequireWritePrivileges;
import com.ubnt.service.teleport.I;
import com.ubnt.service.teleport.K;
import com.ubnt.service.teleport.OoOO;
import com.ubnt.service.teleport.TeleportTokenDocument;
import com.ubnt.service.teleport.Y;
import com.ubnt.service.teleport.floatnew;
import com.ubnt.service.teleport.forsuper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Api(tags={"Teleport"})
public class TeleportController {
    private static final String \u00d200000 = "https://teleport.ui.link/";
    private static final String Object = "********-****-****-****-********";
    private final floatnew o00000;

    public TeleportController(floatnew floatnew2) {
        this.o00000 = floatnew2;
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/token"})
    @ApiOperation(value="Create new Teleport short-term token")
    @AllowUCoreLocal
    public Publisher<TeleportTokenDto> createNewToken(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d600000(site.getId()).map(r2 -> {
            String string = this.\u00f400000(r2.\u00d300000());
            return TeleportTokenDto.ofDocument(r2.\u00d200000(), string);
        });
    }

    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @ApiOperation(value="Return paginated list of Teleport invitation history", notes="Since 7.2.67")
    @AllowUCoreLocal
    public TeleportInvitationListDto searchInvitationHistory(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        forsuper forsuper2 = this.\u00d200000(modifiableTeleportTokenListParameter, site);
        I i2 = this.o00000.\u00f800000(forsuper2);
        return TeleportInvitationListDto.builder().totalElementCount(i2.\u00d300000()).totalPageCount(i2.\u00d400000()).pageNumber(i2.super()).data(this.int(i2.\u00d200000())).build();
    }

    @RequireWritePrivileges
    @PostMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @ApiOperation(value="Return paginated list of Teleport invitation history", notes="Since 8.0.22")
    @AllowUCoreLocal
    public TeleportInvitationListDto postSearchInvitationHistory(@PathVariable(value="siteName") Site site, @RequestBody @Valid ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        return this.searchInvitationHistory(site, modifiableTeleportTokenListParameter);
    }

    @Deprecated
    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/token"})
    @ApiOperation(value="Return paginated list of Teleport active short-term tokens", notes="Since 7.1.2")
    public TeleportTokenListDto searchActiveShortTermTokens(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        forsuper forsuper2 = this.\u00d200000(modifiableTeleportTokenListParameter, site);
        OoOO ooOO2 = this.o00000.\u00f500000(forsuper2);
        return TeleportTokenListDto.builder().totalElementCount(ooOO2.\u00d300000()).totalPageCount(ooOO2.\u00d400000()).pageNumber(ooOO2.super()).data(this.\u00d600000(ooOO2.\u00d200000())).build();
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/token/{tokenId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Remove Teleport short-term token", notes="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> removeShortTermToken(@PathVariable(value="siteName") Site site, @PathVariable(value="tokenId") String string) {
        return this.o00000.for(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/disconnect-client/{clientId}"})
    @ApiOperation(value="Disconnect Teleport client", notes="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> disconnectClient(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.o00000.o00000(site.getId(), string).flatMap(teleportClientDocument -> Mono.empty());
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/client/{clientId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Remove client and their token")
    @AllowUCoreLocal
    public Publisher<Void> removeClientAndToken(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.o00000.\u00d500000(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/access-request"})
    @ApiOperation(value="Create new Teleport long-term token", notes="Since 7.2.6")
    @RequireConsoleOwner
    public Publisher<TeleportAccessResponseDto> createNewLongTermTokenForOwner(@PathVariable(value="siteName") Site site, @Valid @RequestBody TeleportAccessRequestDto teleportAccessRequestDto) {
        return this.o00000.\u00d300000(site.getId(), K.o00000(teleportAccessRequestDto)).map(TeleportAccessResponseDto::ofDocument);
    }

    private forsuper \u00d200000(ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter, Site site) {
        ImmutableTeleportTokenListParameter immutableTeleportTokenListParameter = modifiableTeleportTokenListParameter.toImmutable();
        return forsuper.o00000().\u00d800000(site.getId()).\u00d200000(immutableTeleportTokenListParameter.getPageNumber()).\u00d400000(immutableTeleportTokenListParameter.getPageSize()).\u00d300000();
    }

    private String \u00f400000(String string) {
        return \u00d200000 + string;
    }

    private List<TeleportTokenDto> \u00d600000(List<TeleportTokenDocument> list) {
        return list.stream().map(this::\u00d800000).collect(Collectors.toList());
    }

    private TeleportTokenDto \u00d800000(TeleportTokenDocument teleportTokenDocument) {
        String string = this.\u00d300000(teleportTokenDocument.getSecretIdentifier());
        return TeleportTokenDto.ofDocument(teleportTokenDocument, string);
    }

    private List<TeleportInvitationDto> int(List<Y> list) {
        return list.stream().map(y2 -> TeleportInvitationDto.builder().client(y2.\u00f400000()).creationTimestamp(y2.return()).expirationTimestamp(y2.\u00d400000()).invitationStatus(y2.\u00d800000()).invitationTokenId(y2.\u00d300000()).invitationUrl(this.\u00d300000(y2.o00000())).tokenId(y2.\u00d500000()).build()).collect(Collectors.toList());
    }

    private String \u00d300000(String string) {
        return "https://teleport.ui.link/********-****-****-****-********" + string;
    }
}

