/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.systemlog.device;

import com.ubnt.data.Site;
import com.ubnt.model.api.systemlog.device.ApLogListParameterDto;
import com.ubnt.model.api.systemlog.device.DeviceLogDto;
import com.ubnt.model.api.systemlog.device.DeviceLogDtoList;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.systemlog.device.DeviceLogScope;
import com.ubnt.service.alert.AlertDocument;
import com.ubnt.service.systemlog.device.C;
import com.ubnt.service.systemlog.device.O0OO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Validated
@Api(tags={"Device Log"})
public class DeviceLogController {
    private final C o00000;
    private final O0OO \u00d200000;

    public DeviceLogController(C c2, O0OO o0OO2) {
        this.o00000 = c2;
        this.\u00d200000 = o0OO2;
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/device/{deviceMac}"})
    @ApiOperation(value="List all device logs")
    public List<DeviceLogDto> listDeviceLogs(@PathVariable(value="siteName") Site site, @PathVariable(value="deviceMac") String string, @RequestParam(value="scope", defaultValue="DEVICE") DeviceLogScope deviceLogScope, @RequestParam(value="limit", defaultValue="5") @Min(value=1L) @Min(value=1L) int n2) {
        return this.\u00d200000.o00000(this.o00000.\u00d300000(site.getId(), string, deviceLogScope, n2));
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/ap-logs"})
    @ApiOperation(value="List all AP logs")
    public DeviceLogDtoList listApLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid ApLogListParameterDto apLogListParameterDto) {
        return this.o00000(site, apLogListParameterDto);
    }

    private DeviceLogDtoList o00000(Site site, ApLogListParameterDto apLogListParameterDto) {
        Page<AlertDocument> page = this.o00000.\u00d600000(apLogListParameterDto.toSearchParameters(site.getId()));
        return DeviceLogDtoList.builder().totalPageCount(page.getTotalPages()).totalElementCount(page.getTotalElements()).pageNumber(page.getNumber()).data(this.\u00d200000.o00000(page.getContent())).build();
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/ap-logs/display-options/aps"})
    @ApiOperation(value="List unique MAC addresses of APs for which we have logs")
    public List<String> getUniqueApMacsInApLogs(@PathVariable(value="siteName") Site site) {
        return this.o00000.super(site.getId());
    }
}

