/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.notification;

import com.ubnt.data.Site;
import com.ubnt.model.api.notification.NotificationDto;
import com.ubnt.net.security.G;
import com.ubnt.net.security.role.OoOO;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.net.v2.notification.MissingPrincipalCredentials;
import com.ubnt.service.notification.A;
import com.ubnt.service.notification.C;
import com.ubnt.service.notification.D;
import com.ubnt.service.notification.NotificationDocument;
import com.ubnt.service.system.ifObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Api(tags={"Notifications"})
public class NotificationController {
    private static final String \u00d500000 = "admin_id";
    private final A \u00d400000;
    private final G new;
    private final OoOO \u00d300000;
    private final ifObject o00000;

    public NotificationController(A a2, G g2, OoOO ooOO2, ifObject ifObject2) {
        this.\u00d400000 = a2;
        this.new = g2;
        this.\u00d300000 = ooOO2;
        this.o00000 = ifObject2;
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/site/{siteName}/notifications"})
    @ApiOperation(value="Get all  site and controller scope notifications for admin")
    public List<NotificationDto> getAdminNotificationsByScope(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.o00000(httpServletRequest, httpServletResponse);
        boolean bl = this.\u00d300000.\u00d300000(httpServletRequest, httpServletResponse, site.getId());
        return this.\u00d400000.\u00d600000(string).stream().filter(notificationDocument -> D.\u00d200000 == notificationDocument.getScope() || site.getId().equals(notificationDocument.getSiteId())).map(NotificationDto::fromDocument).filter(notificationDto -> this.\u00d400000(bl, (NotificationDto)notificationDto)).collect(Collectors.toList());
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/notifications/{name}"})
    @ApiOperation(value="Find one notification for admin by notification name, scope and site id")
    public NotificationDto getAdminNotification(@PathVariable String string, @RequestParam(value="scope") D d2, @RequestParam(value="site_name", required=false) Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = this.o00000(httpServletRequest, httpServletResponse);
        String string3 = site == null ? null : site.getId();
        C c2 = new C().\u00d200000(string).\u00d800000(string2).o00000(d2).\u00d600000(string3);
        NotificationDocument notificationDocument = this.\u00d400000.class(c2);
        return NotificationDto.fromDocument(notificationDocument);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PostMapping(value={"/api/notifications"})
    @ApiOperation(value="Create a notification for admin")
    public NotificationDto createNotification(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.o00000(httpServletRequest, httpServletResponse);
        String string2 = this.\u00d500000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).int().\u00d600000();
        NotificationDocument notificationDocument2 = this.\u00d400000.super(notificationDocument);
        return NotificationDto.fromDocument(notificationDocument2);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PutMapping(value={"/api/notifications"})
    @ApiOperation(value="Update admins notification")
    public NotificationDto updateNotification(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.o00000(httpServletRequest, httpServletResponse);
        String string2 = this.\u00d500000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).\u00d600000();
        NotificationDocument notificationDocument2 = this.\u00d400000.\u00d400000(notificationDocument);
        return NotificationDto.fromDocument(notificationDocument2);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PostMapping(value={"/api/notifications/dismiss-global"})
    @ApiOperation(value="Dismiss all related notifications")
    public List<NotificationDto> dismissRelatedNotifications(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.o00000(httpServletRequest, httpServletResponse);
        String string2 = this.\u00d500000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).int().\u00d600000();
        List<NotificationDocument> list = this.\u00d400000.\u00f400000(notificationDocument);
        return list.stream().map(NotificationDto::fromDocument).collect(Collectors.toList());
    }

    private String o00000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.new.o00000(httpServletRequest, httpServletResponse).map(x2 -> x2.getString(\u00d500000)).orElseThrow(() -> new MissingPrincipalCredentials(new String[]{\u00d500000}));
    }

    private String \u00d500000(NotificationDto notificationDto) {
        return notificationDto.getSiteId().orElseGet(this.return(notificationDto));
    }

    private Supplier<String> return(NotificationDto notificationDto) {
        return () -> notificationDto.getSiteName().map(this.o00000::floatdonew).orElse(null);
    }

    private boolean \u00d400000(boolean bl, NotificationDto notificationDto) {
        return BooleanUtils.isNotTrue((Boolean)notificationDto.isGlobal()) || bl;
    }
}

