/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.lan;

import com.ubnt.data.Site;
import com.ubnt.model.api.lan.EnableLteFailoverRequest;
import com.ubnt.model.api.lan.EnrichedLanConfiguration;
import com.ubnt.model.api.lan.LanConfigurationDto;
import com.ubnt.model.api.lan.MigrateNetworkToLayer3Request;
import com.ubnt.net.security.role.OoOO;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.lan.configuration.super;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Validated
@V2RestController
@Api(tags={"LAN Configuration"})
public class LanConfigurationController {
    private final super \u00d200000;
    private final OoOO super;

    public LanConfigurationController(super super_, OoOO ooOO2) {
        this.\u00d200000 = super_;
        this.super = ooOO2;
    }

    @ApiOperation(value="Get default LAN Network settings", notes="Since 6.6.31")
    @GetMapping(value={"/api/site/{siteName}/lan/defaults"})
    public LanConfigurationDto getDefaults(@PathVariable(value="siteName") Site site) {
        return LanConfigurationDto.ofLegacy(this.\u00d200000.\u00d3O0000());
    }

    @GetMapping(value={"/api/site/{siteName}/lan/enriched-configuration"})
    public List<EnrichedLanConfiguration> getConfigurations(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00d4O0000(site.getId());
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Batch enable LTE failover for LANs, disable for other LANs")
    @PutMapping(value={"/api/site/{siteName}/lan/enable-lte-failover"})
    public void enableLteFailoverForNetworks(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @RequestBody @Valid EnableLteFailoverRequest enableLteFailoverRequest) {
        this.super.\u00d400000(httpServletRequest, httpServletResponse, site.getId());
        this.\u00d200000.\u00d600000(site.getId(), enableLteFailoverRequest.networkIds());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Migrate Local Network to Layer3 Network", notes="Since 7.2.45")
    @PostMapping(value={"/api/site/{siteName}/lan/migrate-to-layer3/{networkConfId}"})
    public EnrichedLanConfiguration migrateNetworkToLayer3(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @PathVariable(value="networkConfId") String string, @RequestBody @Valid MigrateNetworkToLayer3Request migrateNetworkToLayer3Request) {
        this.super.\u00d400000(httpServletRequest, httpServletResponse, site.getId());
        return this.\u00d200000.\u00d2O0000(site.getId(), string, migrateNetworkToLayer3Request.gatewayDevice());
    }
}

