/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.isp;

import com.google.common.collect.ImmutableList;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.isp.ConnectionStatisticsDto;
import com.ubnt.model.api.isp.ConnectionStatusDto;
import com.ubnt.model.api.isp.ImmutableIspHealthStatusCompactedDto;
import com.ubnt.model.api.isp.IspHealthDto;
import com.ubnt.model.api.isp.IspHealthPeriodDto;
import com.ubnt.model.api.isp.IspHealthStatusCompactedDto;
import com.ubnt.model.api.isp.IspHealthStatusDto;
import com.ubnt.model.api.isp.IspStatusDto;
import com.ubnt.model.api.speedtest.SpeedtestDto;
import com.ubnt.model.oo0O;
import com.ubnt.net.security.role.OoOO;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.isp.IspHealthCompactService;
import com.ubnt.service.alert.D;
import com.ubnt.service.alert.HA;
import com.ubnt.service.alert.JA;
import com.ubnt.service.alert.M;
import com.ubnt.service.alert.OO00;
import com.ubnt.service.alert.floatsuper;
import com.ubnt.service.alert.n;
import com.ubnt.service.alert.voidnew;
import com.ubnt.service.appstate.AppStateLogDocument;
import com.ubnt.service.appstate.B;
import com.ubnt.service.isp.G;
import com.ubnt.service.isp.O00O;
import com.ubnt.service.isp.oooO;
import com.ubnt.service.isp.public;
import com.ubnt.service.stat.A.super;
import com.ubnt.service.system.setting.null;
import com.ubnt.service.system.setting.oO0O;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Api(tags={"Internet Service Provider"})
public class IspController {
    private static final long \u00f800000 = -1L;
    private static final int if = 20;
    private static final List<HA> \u00f400000 = ImmutableList.of((Object)((Object)HA.ObjectObject), (Object)((Object)HA.voidsuper), (Object)((Object)HA.classString), (Object)((Object)HA.intString), (Object)((Object)HA.\u00f6\u00d20000), (Object)((Object)HA.\u00f4\u00d50000), (Object)((Object)HA.\u00f800000), (Object)((Object)HA.\u00f6\u00d60000), (Object)((Object)HA.\u00f400000), (Object)((Object)HA.\u00d4\u00d60000), (Object)((Object)HA.\u00d8o0000));
    private final floatsuper \u00f500000;
    private final JA OO0000;
    private final Clock \u00d400000;
    private final com.ubnt.service.isp.super o00000;
    private final OoOO \u00d300000;
    private final oO0O \u00d800000;
    private final super \u00d500000;
    private final IspHealthCompactService new;
    private final B return;

    public IspController(floatsuper floatsuper2, JA jA, Clock clock, com.ubnt.service.isp.super super_, OoOO ooOO2, oO0O oO0O2, super super_2, IspHealthCompactService ispHealthCompactService, B b2) {
        this.\u00f500000 = floatsuper2;
        this.OO0000 = jA;
        this.\u00d400000 = clock;
        this.o00000 = super_;
        this.\u00d300000 = ooOO2;
        this.\u00d800000 = oO0O2;
        this.\u00d500000 = super_2;
        this.new = ispHealthCompactService;
        this.return = b2;
    }

    @GetMapping(value={"/api/site/{siteName}/isp/status"})
    @ApiOperation(value="ISP status", notes="Since 7.2.50")
    public IspStatusDto getIspStatus(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Instant instant = this.\u00d400000.instant();
        long l2 = instant.minus(1L, ChronoUnit.DAYS).toEpochMilli();
        long l3 = instant.minus(7L, ChronoUnit.DAYS).toEpochMilli();
        long l4 = instant.toEpochMilli();
        AlertListDto alertListDto = this.\u00d200000(site, httpServletRequest, httpServletResponse, l2, l4);
        Optional<O00O> optional = this.o00000.\u00d500000(site);
        List list = this.\u00d500000.return(site.getId(), l3, l4).stream().map(SpeedtestDto::fromX).collect(Collectors.toList());
        Setting setting = this.\u00d800000.\u00d300000(null.\u00f5O0000, site.getId());
        return IspStatusDto.builder().internetAlerts(alertListDto).latencyMax(optional.map(O00O::\u00d400000)).uplinkStatus(this.\u00f500000(optional, O00O::\u00d300000)).wanStatus(this.\u00f500000(optional, O00O::super)).wan2Status(this.\u00f500000(optional, O00O::class)).speedtests(list).pingServer(setting.getOptionalString("echo_server").orElse("ping.ui.com")).build();
    }

    private ConnectionStatusDto \u00f500000(Optional<O00O> optional, Function<O00O, oooO> function) {
        return optional.map(function).map(oooO2 -> ConnectionStatusDto.builder().receivedBytesTotal(oooO2.new()).transmittedBytesTotal(oooO2.\u00d400000()).connectionStatistics(this.\u00d500000(oooO2.\u00d300000())).latencyThreshold(oooO2.o00000()).build()).orElse(ConnectionStatusDto.empty());
    }

    @GetMapping(value={"/api/site/{siteName}/isp/health"})
    @ApiOperation(value="ISP health status for last 24 hours", notes="Since 7.2.59")
    @AllowUCoreLocal
    public IspHealthStatusDto getIspHealth(@PathVariable(value="siteName") Site site) {
        Map<Long, List<AppStateLogDocument>> map = this.return.\u00f600000();
        List list = this.o00000.\u00d6O0000(site, null, null).stream().map(public_ -> this.\u00d400000((public)public_, map)).collect(Collectors.toList());
        return IspHealthStatusDto.builder().healthStatistics(list).build();
    }

    @GetMapping(value={"/api/site/{siteName}/isp/health/compact"})
    @ApiOperation(value="Compacted ISP health status for last 24 hours or time range", notes="Since 7.3.57")
    @AllowUCoreLocal
    public IspHealthStatusCompactedDto getIspHealthCompact(@PathVariable(value="siteName") Site site, @RequestParam(required=false, value="start") Long l2, @RequestParam(required=false, value="end") Long l3) {
        List<public> list = this.o00000.\u00d6O0000(site, l2, l3);
        List<IspHealthPeriodDto> list2 = this.new.o00000(list);
        ImmutableIspHealthStatusCompactedDto.Builder builder = IspHealthStatusCompactedDto.builder();
        builder.periods(list2);
        return builder.build();
    }

    private IspHealthDto \u00d400000(public public_, Map<Long, List<AppStateLogDocument>> map) {
        long l2 = public_.\u00d400000();
        return public_.\u00d800000().isPresent() ? IspHealthDto.missingInterval(l2, this.Object(l2, map)) : IspHealthDto.builder().highLatency(public_.\u00f500000()).packetLoss(public_.o00000()).latencyAvg(public_.if()).latencyMax(public_.\u00d300000()).timestamp(l2).isWanDowntime(public_.\u00f400000()).notReported(public_.\u00d800000()).isWan2FailoverActive(public_.new() > 0L).build();
    }

    private List<AppStateLogDocument> Object(long l2, Map<Long, List<AppStateLogDocument>> map) {
        List<AppStateLogDocument> list = map.get(l2);
        return list == null ? Collections.emptyList() : list;
    }

    private List<ConnectionStatisticsDto> \u00d500000(List<G> list) {
        return list.stream().filter(g2 -> g2.\u00f500000() != -1L && g2.\u00d400000() != -1L).map(g2 -> ConnectionStatisticsDto.builder().latency(g2.\u00f500000()).latencyMax(g2.\u00d400000()).receivedBytesRateAvg(g2.o00000()).transmittedBytesRateAvg(g2.\u00d500000()).timestamp(g2.\u00d200000()).build()).collect(Collectors.toList());
    }

    private AlertListDto \u00d200000(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l2, long l3) {
        n n2 = n.private().\u00d3o0000(site.getId()).\u00f5O0000(this.\u00d300000.o00000(httpServletRequest, httpServletResponse, site.getId())).\u00f4o0000(l2).\u00d5O0000(l3).privatesuper(false).while(\u00f400000).\u00d300000(20).\u00f800000(D.\u00d200000(voidnew.\u00d300000, oo0O.o00000)).\u00d8O0000(M.new, M.o00000, M.\u00d500000, M.\u00d400000).oo0000();
        OO00 oO002 = this.OO0000.o00000(n2);
        return AlertListDto.builder().totalElementCount(oO002.\u00d300000()).totalPageCount(oO002.\u00d400000()).pageNumber(oO002.super()).data(this.\u00f500000.Object(oO002.\u00d200000())).build();
    }
}

