/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.insight.filtering;

import com.ubnt.data.Site;
import com.ubnt.model.api.insights.filtering.FilteringInsightsOverviewDto;
import com.ubnt.model.api.insights.filtering.FilteringInsightsOverviewQueryParams;
import com.ubnt.model.api.insights.filtering.FilteringInsightsWatchlistDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.filtering.statistics.super;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Validated
@Api(tags={"Filtering Insights"})
public class FilteringInsightsController {
    private final super o00000;

    public FilteringInsightsController(super super_) {
        this.o00000 = super_;
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/insights/filtering/overview"})
    @ApiOperation(value="Get time-series statistics for Insights Filtering Overview", notes="Since 7.3.40")
    public FilteringInsightsOverviewDto getInsightsFilteringOverview(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @ApiParam(value="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @ApiParam(value="Filter end in unix epoch seconds") Long l3, @RequestBody FilteringInsightsOverviewQueryParams filteringInsightsOverviewQueryParams) {
        return FilteringInsightsOverviewDto.of(this.o00000.new(site.getId(), l2, l3, filteringInsightsOverviewQueryParams));
    }

    @GetMapping(value={"/api/site/{siteName}/insights/filtering/watchlist"})
    @ApiOperation(value="Get clients with statistics for Insights Filtering Watchlist", notes="Since 7.3.33")
    public FilteringInsightsWatchlistDto getInsightsFilteringWatchlist(@PathVariable(value="siteName") Site site, @RequestParam(value="start") Long l2, @RequestParam(value="end") Long l3) {
        return FilteringInsightsWatchlistDto.of(this.o00000.o00000(site.getId(), l2, l3));
    }
}

