/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.dpi;

import com.ubnt.data.Site;
import com.ubnt.model.api.dpi.AggregatedDpiDto;
import com.ubnt.model.api.dpi.DpiDto;
import com.ubnt.net.security.role.OoOO;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.stat.dpi.dosuper;
import com.ubnt.service.stat.dpi.intsuper;
import com.ubnt.service.stat.dpi.oOOO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Api(tags={"DPI"})
public class DpiController {
    private final oOOO \u00d300000;
    private final OoOO \u00d200000;
    private final dosuper o00000;

    public DpiController(oOOO oOOO2, OoOO ooOO2, dosuper dosuper2) {
        this.\u00d300000 = oOOO2;
        this.\u00d200000 = ooOO2;
        this.o00000 = dosuper2;
    }

    @GetMapping(value={"/api/site/{siteName}/dpi"})
    @ApiOperation(value="List all DPI stats")
    public List<DpiDto> listAllDpiStats(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom", required=false) Long l2, @RequestParam(value="timestampTo", required=false) Long l3) {
        return this.\u00d300000.\u00d300000(site.getId(), l2, l3).stream().map(DpiDto::fromDocument).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/dpi/site"})
    @ApiOperation(value="List site DPI stats")
    public List<DpiDto> listSiteDpiStats(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom", required=false) Long l2, @RequestParam(value="timestampTo", required=false) Long l3) {
        return this.\u00d300000.\u00f600000(site.getId(), l2, l3).stream().map(DpiDto::fromDocument).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/dpi/client"})
    @ApiOperation(value="List client DPI stats")
    public List<DpiDto> listClientDpiStats(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom", required=false) Long l2, @RequestParam(value="timestampTo", required=false) Long l3) {
        return this.\u00d300000.\u00d5o0000(site.getId(), l2, l3).stream().map(DpiDto::fromDocument).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/dpi/client/changes"})
    @ApiOperation(value="List first and last client DPI stats")
    public List<AggregatedDpiDto> listClientDpiChanges(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom", required=false) Long l2, @RequestParam(value="timestampTo", required=false) Long l3) {
        return this.\u00d300000.\u00d600000(intsuper.if(site.getId(), l2, l3, false)).stream().map(AggregatedDpiDto::fromDocument).collect(Collectors.toList());
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Delete site DPI stats")
    @DeleteMapping(value={"/api/site/{siteName}/dpi"})
    public void deleteSiteDpiStats(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site) {
        this.\u00d200000.new(httpServletRequest, httpServletResponse, site.getId());
        this.\u00d300000.\u00d3O0000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/dpi/latest-client-stats"})
    @ApiOperation(value="List client DPI live stats")
    public List<DpiDto> listLiveClientDpiStats(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d300000(site.getId()).stream().map(DpiDto::clientFromX).collect(Collectors.toList());
    }
}

