/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.alert;

import com.ubnt.data.Site;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.alert.AlertListParameterDto;
import com.ubnt.model.api.alert.AlertSettingDto;
import com.ubnt.model.api.alert.AlertSettingUpdateDto;
import com.ubnt.model.api.alert.AlertTypeSettingUpdateDto;
import com.ubnt.model.api.alert.ClientAlertListParameterDto;
import com.ubnt.model.api.alert.DashboardAlertListDto;
import com.ubnt.model.api.alert.ModifiableAlertListParameterDto;
import com.ubnt.model.api.alert.SystemCriticalAlertListParameterDto;
import com.ubnt.model.api.alert.UpdateAlertListParameterDto;
import com.ubnt.net.security.G;
import com.ubnt.net.security.role.OoOO;
import com.ubnt.net.security.role.String;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.exception.UserNotAuthenticatedException;
import com.ubnt.service.alert.AlertDocument;
import com.ubnt.service.alert.D;
import com.ubnt.service.alert.DA;
import com.ubnt.service.alert.JA;
import com.ubnt.service.alert.OO00;
import com.ubnt.service.alert.floatsuper;
import com.ubnt.service.alert.intsuper;
import com.ubnt.service.alert.n;
import com.ubnt.service.alert.setting.AlertSettingDocument;
import com.ubnt.service.alert.setting.AlertTypeSettingDocument;
import com.ubnt.service.alert.setting.B;
import com.ubnt.service.alert.setting.return;
import com.ubnt.service.alert.whilenew;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Api(tags={"Alerts"})
public class AlertController {
    private final DA \u00d500000;
    private final JA \u00d200000;
    private final return \u00d400000;
    private final whilenew void;
    private final OoOO \u00d600000;
    private final floatsuper o00000;
    private final G Object;

    public AlertController(DA dA2, whilenew whilenew2, JA jA, return return_, OoOO ooOO2, floatsuper floatsuper2, G g2) {
        this.\u00d500000 = dA2;
        this.void = whilenew2;
        this.\u00d200000 = jA;
        this.\u00d400000 = return_;
        this.\u00d600000 = ooOO2;
        this.o00000 = floatsuper2;
        this.Object = g2;
    }

    @GetMapping(value={"/api/site/{siteName}/alert"})
    @ApiOperation(value="List Alerts")
    public AlertListDto listAlerts(@PathVariable(value="siteName") Site site, ModifiableAlertListParameterDto modifiableAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00f600000(site, modifiableAlertListParameterDto.toImmutable(), httpServletRequest, httpServletResponse);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/system-critical-alert"})
    public AlertListDto listSystemCriticalAlerts(@PathVariable(value="siteName") Site site, @RequestBody @Valid SystemCriticalAlertListParameterDto systemCriticalAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d800000(httpServletRequest, httpServletResponse, site, systemCriticalAlertListParameterDto);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/update-alert"})
    public AlertListDto listUpdateAlerts(@PathVariable(value="siteName") Site site, @RequestBody @Valid UpdateAlertListParameterDto updateAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d3O0000(httpServletRequest, httpServletResponse, site, updateAlertListParameterDto);
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/client-alert"})
    public AlertListDto listClientAlerts(@PathVariable(value="siteName") Site site, @RequestBody @Valid ClientAlertListParameterDto clientAlertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d400000(httpServletRequest, httpServletResponse, site, clientAlertListParameterDto);
    }

    @GetMapping(value={"/api/site/{siteName}/alert/dashboard"})
    @ApiOperation(value="List Alerts")
    public DashboardAlertListDto listDashboardAlerts(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        List<AlertDocument> list = this.void.\u00d6o0000(site.getId(), string);
        return DashboardAlertListDto.builder().data(this.o00000.Object(list)).build();
    }

    @PutMapping(value={"/api/site/{siteName}/alert/dashboard/mark-all-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Mark as read aggregated dashboard alerts. It means that marking one of them as read should mark also another from the same group")
    public void markAllDashboardAlertsAsRead(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        this.void.interface(site.getId(), string);
    }

    @PutMapping(value={"/api/site/{siteName}/alert/dashboard/{alertId}/mark-as-read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Mark as read aggregated dashboard alerts. It means that marking one of them as read should mark also another from the same group")
    public void markDashboardAlertAsRead(@PathVariable(value="siteName") Site site, @PathVariable(value="alertId") java.lang.String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string2 = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        this.void.\u00d200000(site.getId(), string2, string);
    }

    @GetMapping(value={"/api/site/{siteName}/alert/setting"})
    @ApiOperation(value="Get Alert settings")
    public AlertSettingDto getSettings(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00f800000(httpServletRequest, httpServletResponse, string -> this.\u00d300000((java.lang.String)string, site.getId()));
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/setting"})
    @ApiOperation(value="Get System log settings")
    public AlertSettingDto getSystemLogSettings(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00f800000(httpServletRequest, httpServletResponse, string -> AlertSettingDto.fromDocument(this.\u00d400000.\u00d400000((java.lang.String)string, site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/alert/setting"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update Alert settings")
    public AlertSettingDto updateSettings(@PathVariable(value="siteName") Site site, @RequestBody AlertSettingUpdateDto alertSettingUpdateDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00f800000(httpServletRequest, httpServletResponse, string -> {
            this.\u00d400000.o00000((java.lang.String)string, alertSettingDocument -> this.\u00f400000(alertSettingUpdateDto, (AlertSettingDocument)alertSettingDocument));
            return this.\u00d300000((java.lang.String)string, site.getId());
        });
    }

    @PutMapping(value={"/api/site/{siteName}/system-log/setting"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update System log settings")
    public AlertSettingDto updateSystemLogSettings(@PathVariable(value="siteName") Site site, @RequestBody AlertSettingUpdateDto alertSettingUpdateDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00f800000(httpServletRequest, httpServletResponse, string -> {
            this.\u00d400000.o00000((java.lang.String)string, alertSettingDocument -> this.\u00f400000(alertSettingUpdateDto, (AlertSettingDocument)alertSettingDocument));
            return AlertSettingDto.fromDocument(this.\u00d400000.\u00d400000((java.lang.String)string, site.getId()));
        });
    }

    private AlertSettingDto \u00d300000(java.lang.String string, java.lang.String string2) {
        List<intsuper> list = this.\u00d400000.return();
        return AlertSettingDto.fromDocumentForLegacyNotifications(this.\u00d400000.\u00d400000(string, string2), list);
    }

    private AlertSettingDto \u00f800000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Function<java.lang.String, AlertSettingDto> function) {
        return this.Object.o00000(httpServletRequest, httpServletResponse).flatMap(x2 -> Optional.ofNullable(x2.getString("admin_id"))).map(function).orElseThrow(() -> new UserNotAuthenticatedException(httpServletRequest.getRequestURI()));
    }

    private AlertListDto \u00d800000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, SystemCriticalAlertListParameterDto systemCriticalAlertListParameterDto) {
        String string = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        OO00 oO002 = this.\u00d200000.\u00f600000(site, systemCriticalAlertListParameterDto, string);
        return AlertListDto.builder().totalElementCount(oO002.\u00d300000()).totalPageCount(oO002.\u00d400000()).pageNumber(oO002.super()).data(this.o00000.Object(oO002.\u00d200000())).build();
    }

    private AlertListDto \u00d3O0000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, UpdateAlertListParameterDto updateAlertListParameterDto) {
        String string = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        OO00 oO002 = this.\u00d200000.\u00d300000(site, updateAlertListParameterDto, string);
        return AlertListDto.builder().totalElementCount(oO002.\u00d300000()).totalPageCount(oO002.\u00d400000()).pageNumber(oO002.super()).data(this.o00000.Object(oO002.\u00d200000())).build();
    }

    private AlertListDto \u00d400000(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Site site, ClientAlertListParameterDto clientAlertListParameterDto) {
        String string = this.\u00d200000(site, httpServletRequest, httpServletResponse);
        OO00 oO002 = this.\u00d200000.String(site, clientAlertListParameterDto, string);
        return AlertListDto.builder().totalElementCount(oO002.\u00d300000()).totalPageCount(oO002.\u00d400000()).pageNumber(oO002.super()).data(this.o00000.Object(oO002.\u00d200000())).build();
    }

    private AlertListDto \u00f600000(Site site, AlertListParameterDto alertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        n n2 = this.interface(site, alertListParameterDto, httpServletRequest, httpServletResponse);
        OO00 oO002 = this.\u00d200000.o00000(n2);
        return AlertListDto.builder().totalElementCount(oO002.\u00d300000()).totalPageCount(oO002.\u00d400000()).pageNumber(oO002.super()).data(this.o00000.Object(oO002.\u00d200000())).build();
    }

    private n interface(Site site, AlertListParameterDto alertListParameterDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return n.private().\u00d3o0000(site.getId()).\u00f5O0000(this.\u00d200000(site, httpServletRequest, httpServletResponse)).\u00f500000(alertListParameterDto.getTimestampFrom()).if(alertListParameterDto.getTimestampTo()).privatesuper(true).\u00d500000(alertListParameterDto.getPageNumber()).\u00d300000(alertListParameterDto.getPageSize()).\u00f800000(D.\u00d200000(alertListParameterDto.getSortByField(), alertListParameterDto.getSortDirection())).\u00f4O0000(alertListParameterDto.dashboardOnly()).return(alertListParameterDto.getAlertTypeCategory()).oo0000();
    }

    private AlertSettingDocument \u00f400000(AlertSettingUpdateDto alertSettingUpdateDto, AlertSettingDocument alertSettingDocument) {
        B b2 = B.o00000 == alertSettingUpdateDto.settingPreference() ? B.\u00d300000 : alertSettingUpdateDto.settingPreference();
        return alertSettingDocument.builderOfCurrent().super(b2).class(this.\u00d600000(alertSettingUpdateDto)).\u00d200000();
    }

    private Map<intsuper, AlertTypeSettingDocument> \u00d600000(AlertSettingUpdateDto alertSettingUpdateDto) {
        if (B.\u00d300000 == alertSettingUpdateDto.settingPreference() || B.o00000 == alertSettingUpdateDto.settingPreference()) {
            return alertSettingUpdateDto.alertTypeSettings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AlertTypeSettingUpdateDto)entry.getValue()).toDocument()));
        }
        return Collections.emptyMap();
    }

    private String \u00d200000(Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d600000.o00000(httpServletRequest, httpServletResponse, site.getId());
    }
}

