/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.ace.view.C;
import com.ubnt.data.Site;
import com.ubnt.model.api.uid.UidClientInfoDto;
import com.ubnt.model.api.uid.UidRadiusConfiguration;
import com.ubnt.model.api.uid.UidVpnServerConfigurationDto;
import com.ubnt.model.api.wlan.WlanConfiguration;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.uid.B;
import com.ubnt.service.uid.new.A;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Api(tags={"UID"})
public class UidController {
    private final B o00000;

    public UidController(B b2) {
        this.o00000 = b2;
    }

    @ModelAttribute
    public void populateRequestActor(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("actor", (Object)C.String);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/radius-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get default (UDAPI) RADIUS Server Configuration")
    public UidRadiusConfiguration getDefaultRadiusConfiguration(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d6O0000(site.getId()).orElseThrow(() -> new ResourceNotFoundException("UID RADIUS configuration is not found"));
    }

    @PostMapping(value={"/api/site/{siteName}/uid/radius-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update default (UDAPI) RADIUS Server Configuration")
    public UidRadiusConfiguration updateDefaultRadiusConfiguration(@PathVariable(value="siteName") Site site, @RequestBody UidRadiusConfiguration uidRadiusConfiguration) {
        return this.o00000.oO0000(site.getId(), uidRadiusConfiguration);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/wlan"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get Wireless Networks")
    public List<WlanConfiguration> getUidWiFiNetworks(@PathVariable(value="siteName") Site site) {
        return this.o00000.supersuper(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/uid/wlan"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create an UID Wireless Network")
    public WlanConfiguration createWlan(@PathVariable(value="siteName") Site site, @Valid @RequestBody WlanConfiguration wlanConfiguration) {
        return this.o00000.\u00d200000(site.getId(), wlanConfiguration);
    }

    @PutMapping(value={"/api/site/{siteName}/uid/wlan/{wlanId}"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update an UID Wireless Network")
    public WlanConfiguration updateWlan(@PathVariable(value="siteName") Site site, @PathVariable(value="wlanId") String string, @Valid @RequestBody WlanConfiguration wlanConfiguration) {
        return this.o00000.o00000(site.getId(), string, wlanConfiguration);
    }

    @DeleteMapping(value={"/api/site/{siteName}/uid/wlan/{wlanId}"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Delete an UID Wireless Network")
    public void deleteWlan(@PathVariable(value="siteName") Site site, @PathVariable(value="wlanId") String string) {
        this.o00000.\u00d500000(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get UID VPN Server Configuration")
    public UidVpnServerConfigurationDto getVpnConfiguration(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d2O0000(site.getId()).orElseThrow(() -> new ResourceNotFoundException("UID VPN is not configured yet"));
    }

    @PostMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Create or update UID VPN Server Configuration")
    public UidVpnServerConfigurationDto updateVpnConfiguration(@PathVariable(value="siteName") Site site, @Valid @RequestBody UidVpnServerConfigurationDto uidVpnServerConfigurationDto) {
        return this.o00000.\u00d600000(site.getId(), uidVpnServerConfigurationDto);
    }

    @DeleteMapping(value={"/api/site/{siteName}/uid/vpn-server"})
    @RequireUCoreLocal
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiOperation(value="Delete UID VPN Server Configuration")
    public void deleteVpnConfiguration(@PathVariable(value="siteName") Site site) {
        String string = site.getId();
        this.o00000.\u00d2O0000(string).orElseThrow(() -> new ResourceNotFoundException("UID VPN is not configured yet"));
        this.o00000.void(string);
    }

    @PostMapping(value={"/api/site/{siteName}/uid/vpn-server/kick/{username}"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @ApiOperation(value="Disconnect UID VPN Client")
    public void disconnectVpnClient(@PathVariable(value="siteName") Site site, @PathVariable(value="username") @NotEmpty String string) {
        this.o00000.Object(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/uid/client-info/{clientMac}"})
    @RequireUCoreLocal
    @ApiOperation(value="Get UID WiFi Client Info")
    public UidClientInfoDto getClientInfo(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") @MacAddress String string) {
        A a2 = this.o00000.\u00d5O0000(site.getId(), string);
        return UidClientInfoDto.fromUidClientInfo(a2);
    }
}

