/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.X;
import com.ubnt.model.api.Timezone;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.service.system.QA;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Api(tags={"Timezone"})
public class TimezoneController {
    private final QA o00000;

    public TimezoneController(QA qA2) {
        this.o00000 = qA2;
    }

    @AllowPrivilege(value={"admin", "readonly"})
    @GetMapping(value={"/api/timezones"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<Timezone> getTimezones() {
        X x2 = this.o00000.\u00f4\u00d3\u00d5000();
        LocalDateTime localDateTime = LocalDateTime.now();
        List<Timezone> list = x2.keySet().stream().filter(string -> this.\u00d200000((String)string)).map(string -> {
            ZoneId zoneId = ZoneId.of(string);
            ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
            ZoneOffset zoneOffset = zonedDateTime.getOffset();
            String string2 = zoneOffset.getId().replaceAll("Z", "+00:00");
            return new AbstractMap.SimpleEntry<ZoneOffset, Timezone>(zoneOffset, new Timezone((String)string, string2));
        }).sorted(Comparator.comparing(AbstractMap.SimpleEntry::getKey).reversed()).map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList());
        return list;
    }

    private boolean \u00d200000(String string) {
        try {
            ZoneId.of(string);
            return true;
        }
        catch (ZoneRulesException zoneRulesException) {
            return false;
        }
    }
}

