/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.speedtest.LastSpeedTestDto;
import com.ubnt.model.api.speedtest.SpeedtestDto;
import com.ubnt.model.api.speedtest.SpeedtestListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.stat.A.B;
import com.ubnt.service.stat.A.super;
import com.ubnt.service.system.setting.null;
import com.ubnt.service.system.setting.oO0O;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Api(tags={"Speed Test"})
public class SpeedTestController {
    private final super \u00d200000;
    private final B \u00d400000;
    private final Clock super;
    private final oO0O \u00d300000;

    public SpeedTestController(super super_, B b2, Clock clock, oO0O oO0O2) {
        this.\u00d200000 = super_;
        this.\u00d400000 = b2;
        this.super = clock;
        this.\u00d300000 = oO0O2;
    }

    @GetMapping(value={"/api/site/{siteName}/speedtest"})
    @ApiOperation(value="List historical speed test results")
    public SpeedtestListDto getHistoricalSpeedTestResults(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom") Optional<Long> optional, @RequestParam(value="timestampTo") Optional<Long> optional2) {
        List list = this.\u00d200000.return(site.getId(), optional.orElse(Long.MIN_VALUE), optional2.orElse(Long.MAX_VALUE)).stream().map(SpeedtestDto::fromX).collect(Collectors.toList());
        return SpeedtestListDto.builder().data(list).build();
    }

    @GetMapping(value={"/api/site/{siteName}/speedtest/latest"})
    @ApiOperation(value="Get last speed test result", notes="Since 7.2.51")
    public LastSpeedTestDto getLastSpeedTestResult(@PathVariable(value="siteName") Site site) {
        Optional<SpeedtestDto> optional = this.\u00d200000.\u00d500000(site.getId()).map(SpeedtestDto::fromX);
        Setting setting = this.\u00d300000.\u00d300000(null.\u00d2o0000, site.getId());
        return LastSpeedTestDto.builder().speedTestLatest(optional).cronSchedule(this.super(setting)).build();
    }

    private Optional<String> super(Setting setting) {
        return setting.isEnabled() ? setting.getOptionalString("cron_expr") : Optional.empty();
    }

    @GetMapping(path={"/api/site/{siteName}/speedtest/csv"}, produces={"text/csv"})
    @ApiOperation(value="List historical speed test results as csv document")
    public ResponseEntity<Resource> getHistoricalSpeedTestResultsAsCsv(@PathVariable(value="siteName") Site site) {
        String string = this.\u00d400000.o00000(site.getId());
        long l2 = this.super.instant().getEpochSecond();
        String string2 = "speedtest-" + l2 + ".csv";
        ByteArrayResource byteArrayResource = new ByteArrayResource(string.getBytes(StandardCharsets.UTF_8));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + string2})).contentType(MediaType.parseMediaType((String)"text/csv")).contentLength(byteArrayResource.contentLength()).body((Object)byteArrayResource);
    }
}

