/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.Site;
import com.ubnt.model.api.feature.FeatureDescriptionDto;
import com.ubnt.model.api.feature.FeatureVerificationResponse;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.features.M;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@V2RestController
@Api(tags={"Features"})
public class FeaturesController {
    private final M o00000;

    public FeaturesController(M m2) {
        this.o00000 = m2;
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/features"})
    @ApiOperation(value="List application features")
    @AllowUCoreLocal
    public List<String> listFeatures() {
        return this.o00000.\u00d500000();
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/features/{featureName}/exists"})
    @ApiOperation(value="Verify existence of specific feature")
    @AllowUCoreLocal
    public FeatureVerificationResponse featureExists(@PathVariable(value="featureName") @ApiParam(required=true, allowableValues="ALL_UNIFI_DEVICES_PAGE, RADIUS_BATCH_USERS, RADIUS_PROFILES, UID_RADIUS, UID_RADIUS_GROUP_POLICY, UID_VPN, UID_VPN_ALLOW_WAN_LOCAL, UID_VPN_OVERRIDE_DNS, UID_VPN_STRICT_CLIENT_COMMON_NAME, UID_VPN_SUPPORT_UDP, UID_WIFI, UID_WIFI_IOT, UID_WIFI_RADIUS_GROUP_POLICY, LIVE_DEVICE_UPDATES", example="LIVE_DEVICE_UPDATES") String string) {
        return FeatureVerificationResponse.of(this.o00000.null(string));
    }

    @GetMapping(value={"/api/site/{siteName}/features"})
    @ApiOperation(value="List site features")
    @AllowUCoreLocal
    public List<String> listSiteFeatures(@PathVariable(value="siteName") Site site, @RequestParam(value="includeSystemFeatures", defaultValue="false") boolean bl) {
        List<String> list = this.o00000.\u00d600000(site.getId());
        if (bl) {
            list.addAll(this.o00000.\u00d500000());
        }
        return list;
    }

    @GetMapping(value={"/api/site/{siteName}/described-features"})
    @ApiOperation(value="List site features with description")
    @AllowUCoreLocal
    public List<FeatureDescriptionDto> listSiteFeaturesWithDescription(@PathVariable(value="siteName") Site site, @RequestParam(value="includeSystemFeatures", defaultValue="false") boolean bl) {
        return Stream.concat(this.o00000.\u00f500000(site.getId()).stream(), bl ? this.o00000.for().stream() : Stream.empty()).map(FeatureDescriptionDto::of).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/features/{featureName}/exists"})
    @ApiOperation(value="Verify existence of specific site feature")
    @AllowUCoreLocal
    public FeatureVerificationResponse siteFeatureExists(@PathVariable(value="siteName") Site site, @PathVariable(value="featureName") @ApiParam(required=true, allowableValues="WIFI_CONFIG_CREATED", example="WIFI_CONFIG_CREATED") String string) {
        return FeatureVerificationResponse.of(this.o00000.\u00f600000(site.getId(), string));
    }
}

