/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.I.new;
import com.ubnt.model.O0oO.OOoO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@ApiModel(value="WLAN schedule configuration entry", description="Supports duration in minutes")
public class WlanScheduleConfigurationEntry {
    @JsonProperty(value="start_days_of_week")
    @ApiModelProperty(required=true)
    @NotEmpty
    private List<new> startDaysOfWeek;
    @JsonProperty(value="start_hour")
    @ApiModelProperty(required=true, example="1")
    @Min(value=0L)
    @Max(value=23L)
    @NotNull
    private @Min(value=0L) @Max(value=23L) @NotNull Integer startHour;
    @JsonProperty(value="start_minute")
    @ApiModelProperty(required=true, example="1")
    @Min(value=0L)
    @Max(value=59L)
    @NotNull
    private @Min(value=0L) @Max(value=59L) @NotNull Integer startMinute;
    @JsonProperty(value="duration_minutes")
    @ApiModelProperty(required=true, example="1")
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull int durationMinutes;
    @JsonProperty(value="name")
    private String name;

    public List<new> getStartDaysOfWeek() {
        return this.startDaysOfWeek;
    }

    public WlanScheduleConfigurationEntry setStartDaysOfWeek(List<new> list) {
        this.startDaysOfWeek = list;
        return this;
    }

    public Integer getStartHour() {
        return Optional.ofNullable(this.startHour).orElse(0);
    }

    public WlanScheduleConfigurationEntry setStartHour(@Nullable Integer n2) {
        this.startHour = n2;
        return this;
    }

    public Integer getStartMinute() {
        return Optional.ofNullable(this.startMinute).orElse(0);
    }

    public WlanScheduleConfigurationEntry setStartMinute(@Nullable Integer n2) {
        this.startMinute = n2;
        return this;
    }

    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public WlanScheduleConfigurationEntry setDurationMinutes(int n2) {
        this.durationMinutes = n2;
        return this;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public WlanScheduleConfigurationEntry setName(String string) {
        this.name = string;
        return this;
    }

    public static WlanScheduleConfigurationEntry fromLegacy(X x2) {
        return WlanScheduleConfigurationEntry.o00000().\u00f600000(x2);
    }

    public X toLegacy() {
        return WlanScheduleConfigurationEntry.o00000().\u00f500000(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("startDaysOfWeek", this.startDaysOfWeek).append("startHour", (Object)this.startHour).append("startMinute", (Object)this.startMinute).append("durationMinutes", this.durationMinutes).append("name", (Object)this.name).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WlanScheduleConfigurationEntry wlanScheduleConfigurationEntry = (WlanScheduleConfigurationEntry)object;
        return this.durationMinutes == wlanScheduleConfigurationEntry.durationMinutes && this.startDaysOfWeek.equals(wlanScheduleConfigurationEntry.startDaysOfWeek) && Objects.equals(this.startHour, wlanScheduleConfigurationEntry.startHour) && Objects.equals(this.startMinute, wlanScheduleConfigurationEntry.startMinute) && Objects.equals(this.name, wlanScheduleConfigurationEntry.name);
    }

    public int hashCode() {
        return Objects.hash(this.startDaysOfWeek, this.startHour, this.startMinute, this.durationMinutes, this.name);
    }

    private static OOoO<WlanScheduleConfigurationEntry, X> o00000() {
        return OOoO.\u00d200000(WlanScheduleConfigurationEntry.class, X.class).OO0000("start_days_of_week", WlanScheduleConfigurationEntry::getStartDaysOfWeek, WlanScheduleConfigurationEntry::setStartDaysOfWeek, new.class).\u00f400000("start_hour", WlanScheduleConfigurationEntry::getStartHour, WlanScheduleConfigurationEntry::setStartHour).\u00f400000("start_minute", WlanScheduleConfigurationEntry::getStartMinute, WlanScheduleConfigurationEntry::setStartMinute).\u00f400000("duration_minutes", WlanScheduleConfigurationEntry::getDurationMinutes, WlanScheduleConfigurationEntry::setDurationMinutes).\u00d2O0000("name", WlanScheduleConfigurationEntry::getName, WlanScheduleConfigurationEntry::setName).\u00f600000();
    }
}

