/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.network.configuration.NetworkConfiguration;
import com.ubnt.model.api.network.configuration.WanDhcpConfigurationOption;
import com.ubnt.model.api.network.configuration.WanDnsPreference;
import com.ubnt.model.api.wan.Ipv6WanDelegationType;
import com.ubnt.model.api.wan.WanLoadBalanceType;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.WanProviderCapabilityDto;
import com.ubnt.model.api.wan.WanType;
import com.ubnt.model.api.wan.WanTypeV6;
import com.ubnt.model.api.wan.super;
import com.ubnt.net.v2.config.security.View;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.net.v2.validation.constraints.IpCidr;
import com.ubnt.net.v2.validation.constraints.IpV6;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@ApiModel(value="WAN Configuration", description="WAN Configuration")
public class WanConfiguration
extends NetworkConfiguration {
    @JsonProperty(value="report_wan_event")
    private boolean reportWanEvent;
    @JsonProperty(value="wan_dns1")
    private String wanDns1;
    @JsonProperty(value="wan_dns2")
    private String wanDns2;
    @JsonProperty(value="wan_dns_preference")
    private WanDnsPreference wanDnsPreference;
    @JsonProperty(value="wan_dhcp_options")
    private List<WanDhcpConfigurationOption> wanDhcpOptions;
    @JsonProperty(value="wan_dhcpv6_pd_size")
    private Integer wanDhcpV6PdSize;
    @JsonProperty(value="wan_egress_qos")
    private Integer wanEgressQualityOfService;
    @JsonProperty(value="wan_gateway")
    @Ip
    private String wanGateway;
    @JsonProperty(value="wan_gateway_v6")
    @IpV6
    private String wanGatewayV6;
    @JsonProperty(value="wan_ip")
    @Ip
    private String wanIp;
    @JsonProperty(value="wan_ip_aliases")
    @IpCidr
    private List<String> wanIpAliases;
    @JsonProperty(value="wan_ipv6")
    @IpV6
    private String wanIpV6;
    @JsonProperty(value="wan_load_balance_type")
    private WanLoadBalanceType wanLoadBalanceType;
    @JsonProperty(value="wan_load_balance_weight")
    private Integer wanLoadBalanceWeight;
    @JsonProperty(value="wan_netmask")
    private String wanNetmask;
    @JsonProperty(value="wan_networkgroup")
    @ApiModelProperty(required=true)
    private WanNetworkGroup wanNetworkGroup;
    @JsonProperty(value="wan_prefixlen")
    private Integer wanPrefixLength;
    @JsonProperty(value="wan_smartq_down_rate")
    private Integer wanSmartQueueDownRate;
    @JsonProperty(value="wan_smartq_enabled")
    private boolean wanSmartQueuesEnabled;
    @JsonProperty(value="wan_smartq_up_rate")
    private Integer wanSmartQueueUpRate;
    @JsonProperty(value="wan_type")
    private WanType wanType;
    @JsonProperty(value="wan_type_v6")
    private WanTypeV6 wanTypeV6;
    @JsonProperty(value="ipv6_wan_delegation_type")
    private Ipv6WanDelegationType ipv6WanDelegationType;
    @JsonProperty(value="single_network_lan")
    private String singleNetworkLan;
    @JsonProperty(value="wan_username")
    private String wanUsername;
    @JsonProperty(value="wan_vlan")
    @Min(value=2L)
    @Max(value=4009L)
    @ApiModelProperty(value="between 2 and 4009", example="21")
    private @Min(value=2L) @Max(value=4009L) Integer wanVlan;
    @JsonProperty(value="wan_vlan_enabled")
    private boolean wanVlanEnabled;
    @JsonProperty(value="x_wan_password")
    @JsonView(value={View.SiteAdmin.class})
    private String wanPassword;
    @JsonProperty(value="ifname")
    private String ifname;
    @JsonProperty(value="mac_override")
    @MacAddress
    private String macOverride;
    @JsonProperty(value="mac_override_enabled")
    private boolean macOverrideEnabled;
    @JsonProperty(value="wan_provider_capabilities")
    private WanProviderCapabilityDto providerCapabilities;
    @JsonProperty(value="igmp_proxy_upstream")
    private boolean isIgmpProxyUpstream;
    @JsonProperty(value="wan_dhcp_cos")
    private Integer wanDhcpCos;
    @JsonProperty(value="wan_dslite_remote_host")
    private String wanDsLiteRemoteHost;
    @JsonProperty(value="wan_ipv6_dns1")
    private String wanIpv6Dns1;
    @JsonProperty(value="wan_ipv6_dns2")
    private String wanIpv6Dns2;
    @JsonProperty(value="wan_ipv6_dns_preference")
    private WanDnsPreference wanIpv6DnsPreference;

    public boolean isReportWanEvent() {
        return this.reportWanEvent;
    }

    public WanConfiguration setReportWanEvent(boolean bl) {
        this.reportWanEvent = bl;
        return this;
    }

    public WanDnsPreference getWanDnsPreference() {
        return this.wanDnsPreference;
    }

    public WanConfiguration setWanDnsPreference(WanDnsPreference wanDnsPreference) {
        this.wanDnsPreference = wanDnsPreference;
        return this;
    }

    public Optional<String> getWanDns1() {
        return Optional.ofNullable(this.wanDns1);
    }

    public WanConfiguration setWanDns1(String string) {
        this.wanDns1 = string;
        return this;
    }

    public Optional<String> getWanDns2() {
        return Optional.ofNullable(this.wanDns2);
    }

    public WanConfiguration setWanDns2(String string) {
        this.wanDns2 = string;
        return this;
    }

    public List<WanDhcpConfigurationOption> getWanDhcpOptions() {
        return Optional.ofNullable(this.wanDhcpOptions).orElse(Collections.emptyList());
    }

    public WanConfiguration setWanDhcpOptions(List<WanDhcpConfigurationOption> list) {
        this.wanDhcpOptions = list;
        return this;
    }

    public Optional<Integer> getWanDhcpV6PdSize() {
        return Optional.ofNullable(this.wanDhcpV6PdSize);
    }

    public WanConfiguration setWanDhcpV6PdSize(Integer n2) {
        this.wanDhcpV6PdSize = n2;
        return this;
    }

    public Optional<Integer> getWanEgressQualityOfService() {
        return Optional.ofNullable(this.wanEgressQualityOfService);
    }

    public WanConfiguration setWanEgressQualityOfService(Integer n2) {
        this.wanEgressQualityOfService = n2;
        return this;
    }

    public Optional<String> getWanGateway() {
        return Optional.ofNullable(this.wanGateway);
    }

    public WanConfiguration setWanGateway(String string) {
        this.wanGateway = string;
        return this;
    }

    public Optional<String> getWanGatewayV6() {
        return Optional.ofNullable(this.wanGatewayV6);
    }

    public WanConfiguration setWanGatewayV6(String string) {
        this.wanGatewayV6 = string;
        return this;
    }

    public Optional<String> getWanIp() {
        return Optional.ofNullable(this.wanIp);
    }

    public WanConfiguration setWanIp(String string) {
        this.wanIp = string;
        return this;
    }

    public List<String> getWanIpAliases() {
        return Optional.ofNullable(this.wanIpAliases).orElse(Collections.emptyList());
    }

    public WanConfiguration setWanIpAliases(List<String> list) {
        this.wanIpAliases = list;
        return this;
    }

    public Optional<String> getWanIpV6() {
        return Optional.ofNullable(this.wanIpV6);
    }

    public WanConfiguration setWanIpV6(String string) {
        this.wanIpV6 = string;
        return this;
    }

    public Optional<WanLoadBalanceType> getWanLoadBalanceType() {
        return Optional.ofNullable(this.wanLoadBalanceType);
    }

    public WanConfiguration setWanLoadBalanceType(WanLoadBalanceType wanLoadBalanceType) {
        this.wanLoadBalanceType = wanLoadBalanceType;
        return this;
    }

    public Optional<Integer> getWanLoadBalanceWeight() {
        return Optional.ofNullable(this.wanLoadBalanceWeight);
    }

    public WanConfiguration setWanLoadBalanceWeight(Integer n2) {
        this.wanLoadBalanceWeight = n2;
        return this;
    }

    public Optional<String> getWanNetmask() {
        return Optional.ofNullable(this.wanNetmask);
    }

    public WanConfiguration setWanNetmask(String string) {
        this.wanNetmask = string;
        return this;
    }

    public WanNetworkGroup getWanNetworkGroup() {
        return this.wanNetworkGroup;
    }

    public WanConfiguration setWanNetworkGroup(WanNetworkGroup wanNetworkGroup) {
        this.wanNetworkGroup = wanNetworkGroup;
        return this;
    }

    public Optional<Integer> getWanPrefixLength() {
        return Optional.ofNullable(this.wanPrefixLength);
    }

    public WanConfiguration setWanPrefixLength(Integer n2) {
        this.wanPrefixLength = n2;
        return this;
    }

    public Optional<Integer> getWanSmartQueueDownRate() {
        return Optional.ofNullable(this.wanSmartQueueDownRate);
    }

    public WanConfiguration setWanSmartQueueDownRate(Integer n2) {
        this.wanSmartQueueDownRate = n2;
        return this;
    }

    public boolean isWanSmartQueuesEnabled() {
        return this.wanSmartQueuesEnabled;
    }

    public WanConfiguration setWanSmartQueuesEnabled(boolean bl) {
        this.wanSmartQueuesEnabled = bl;
        return this;
    }

    public Optional<Integer> getWanSmartQueueUpRate() {
        return Optional.ofNullable(this.wanSmartQueueUpRate);
    }

    public WanConfiguration setWanSmartQueueUpRate(Integer n2) {
        this.wanSmartQueueUpRate = n2;
        return this;
    }

    public Optional<WanType> getWanType() {
        return Optional.ofNullable(this.wanType);
    }

    public WanConfiguration setWanType(WanType wanType) {
        this.wanType = wanType;
        return this;
    }

    public Optional<WanTypeV6> getWanTypeV6() {
        return Optional.ofNullable(this.wanTypeV6);
    }

    public WanConfiguration setWanTypeV6(WanTypeV6 wanTypeV6) {
        this.wanTypeV6 = wanTypeV6;
        return this;
    }

    public Optional<Ipv6WanDelegationType> getIpv6WanDelegationType() {
        return Optional.ofNullable(this.ipv6WanDelegationType);
    }

    public WanConfiguration setIpv6WanDelegationType(Ipv6WanDelegationType ipv6WanDelegationType) {
        this.ipv6WanDelegationType = ipv6WanDelegationType;
        return this;
    }

    public Optional<String> getSingleNetworkLan() {
        return Optional.ofNullable(this.singleNetworkLan);
    }

    public WanConfiguration setSingleNetworkLan(String string) {
        this.singleNetworkLan = string;
        return this;
    }

    public Optional<String> getWanUsername() {
        return Optional.ofNullable(this.wanUsername);
    }

    public WanConfiguration setWanUsername(String string) {
        this.wanUsername = string;
        return this;
    }

    public Optional<Integer> getWanVlan() {
        return Optional.ofNullable(this.wanVlan);
    }

    public WanConfiguration setWanVlan(Integer n2) {
        this.wanVlan = n2;
        return this;
    }

    public boolean isWanVlanEnabled() {
        return this.wanVlanEnabled;
    }

    public WanConfiguration setWanVlanEnabled(boolean bl) {
        this.wanVlanEnabled = bl;
        return this;
    }

    public Optional<String> getWanPassword() {
        return Optional.ofNullable(this.wanPassword);
    }

    public WanConfiguration setWanPassword(String string) {
        this.wanPassword = string;
        return this;
    }

    public Optional<String> getIfname() {
        return Optional.ofNullable(this.ifname);
    }

    public WanConfiguration setIfname(String string) {
        this.ifname = string;
        return this;
    }

    public WanProviderCapabilityDto getProviderCapabilities() {
        return Optional.ofNullable(this.providerCapabilities).orElse(WanProviderCapabilityDto.createEmpty());
    }

    public WanConfiguration setProviderCapabilities(WanProviderCapabilityDto wanProviderCapabilityDto) {
        this.providerCapabilities = wanProviderCapabilityDto;
        return this;
    }

    public Optional<String> getMacOverride() {
        return Optional.ofNullable(this.macOverride);
    }

    public WanConfiguration setMacOverride(String string) {
        this.macOverride = string;
        return this;
    }

    public boolean isMacOverrideEnabled() {
        return this.macOverrideEnabled;
    }

    public WanConfiguration setMacOverrideEnabled(boolean bl) {
        this.macOverrideEnabled = bl;
        return this;
    }

    public boolean isIgmpProxyUpstream() {
        return this.isIgmpProxyUpstream;
    }

    public WanConfiguration setIgmpProxyUpstream(boolean bl) {
        this.isIgmpProxyUpstream = bl;
        return this;
    }

    public Optional<Integer> getWanDhcpCos() {
        return Optional.ofNullable(this.wanDhcpCos);
    }

    public WanConfiguration setWanDhcpCos(Integer n2) {
        this.wanDhcpCos = n2;
        return this;
    }

    public Optional<String> getWanDsLiteRemoteHost() {
        return Optional.ofNullable(this.wanDsLiteRemoteHost);
    }

    public WanConfiguration setWanDsLiteRemoteHost(String string) {
        this.wanDsLiteRemoteHost = string;
        return this;
    }

    public Optional<String> getWanIpv6Dns1() {
        return Optional.ofNullable(this.wanIpv6Dns1);
    }

    public WanConfiguration setWanIpv6Dns1(String string) {
        this.wanIpv6Dns1 = string;
        return this;
    }

    public Optional<String> getWanIpv6Dns2() {
        return Optional.ofNullable(this.wanIpv6Dns2);
    }

    public WanConfiguration setWanIpv6Dns2(String string) {
        this.wanIpv6Dns2 = string;
        return this;
    }

    public WanDnsPreference getWanIpv6DnsPreference() {
        return this.wanIpv6DnsPreference;
    }

    public WanConfiguration setWanIpv6DnsPreference(WanDnsPreference wanDnsPreference) {
        this.wanIpv6DnsPreference = wanDnsPreference;
        return this;
    }

    public static WanConfiguration fromLegacy(NetworkConf networkConf) {
        return super.o00000(networkConf);
    }

    public NetworkConf toLegacy() {
        return super.\u00d300000(this);
    }
}

