/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.utilization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.utilization.ImmutableIspUtilizationDto;
import com.ubnt.model.api.utilization.WanUtilizationDto;
import com.ubnt.service.utilization.OoOO;
import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableIspUtilizationDto.class)
@ApiModel(value="ISP utilization")
@Value.Immutable
public interface IspUtilizationDto {
    @JsonProperty(value="wan_utilization_up")
    public List<WanUtilizationDto> wanUp();

    @JsonProperty(value="wan_utilization_down")
    public List<WanUtilizationDto> wanDown();

    @JsonProperty(value="wan2_utilization_up")
    public List<WanUtilizationDto> wan2Up();

    @JsonProperty(value="wan2_utilization_down")
    public List<WanUtilizationDto> wan2Down();

    @JsonProperty(value="wan_peak_transmitted_bytes_rate")
    public long wanPeakUp();

    @JsonProperty(value="wan_peak_received_bytes_rate")
    public long wanPeakDown();

    @JsonProperty(value="wan2_peak_transmitted_bytes_rate")
    public long wan2PeakUp();

    @JsonProperty(value="wan2_peak_received_bytes_rate")
    public long wan2PeakDown();

    public static ImmutableIspUtilizationDto.Builder builder() {
        return ImmutableIspUtilizationDto.builder();
    }

    public static IspUtilizationDto fromUtilizationInfo(OoOO ooOO2) {
        return IspUtilizationDto.builder().wanDown(ooOO2.super().stream().map(WanUtilizationDto::fromUtilizationInfo).collect(Collectors.toList())).wanUp(ooOO2.\u00d300000().stream().map(WanUtilizationDto::fromUtilizationInfo).collect(Collectors.toList())).wan2Down(ooOO2.class().stream().map(WanUtilizationDto::fromUtilizationInfo).collect(Collectors.toList())).wan2Up(ooOO2.\u00f400000().stream().map(WanUtilizationDto::fromUtilizationInfo).collect(Collectors.toList())).wanPeakUp(ooOO2.\u00d600000()).wanPeakDown(ooOO2.\u00d200000()).wan2PeakUp(ooOO2.int()).wan2PeakDown(ooOO2.\u00d800000()).build();
    }

    public static IspUtilizationDto empty() {
        return IspUtilizationDto.builder().wanDown(Collections.emptyList()).wanUp(Collections.emptyList()).wan2Down(Collections.emptyList()).wan2Up(Collections.emptyList()).wanPeakUp(0L).wanPeakDown(0L).wan2PeakUp(0L).wan2PeakDown(0L).build();
    }
}

