/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.trafficstats.DpiStatDto;
import com.ubnt.model.api.trafficstats.HistoricalDpiQueryParameters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HistoricalDpiQueryParameters", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableHistoricalDpiQueryParameters
extends HistoricalDpiQueryParameters {
    @Nullable
    private final List<DpiStatDto> selectedApps;
    @Nullable
    private final List<String> selectedClientMacs;

    private ImmutableHistoricalDpiQueryParameters(@Nullable List<DpiStatDto> list, @Nullable List<String> list2) {
        this.selectedApps = list;
        this.selectedClientMacs = list2;
    }

    @Override
    @JsonProperty(value="apps")
    public Optional<List<DpiStatDto>> selectedApps() {
        return Optional.ofNullable(this.selectedApps);
    }

    @Override
    @JsonProperty(value="client_macs")
    public Optional<List<String>> selectedClientMacs() {
        return Optional.ofNullable(this.selectedClientMacs);
    }

    public final ImmutableHistoricalDpiQueryParameters withSelectedApps(List<DpiStatDto> list) {
        List<DpiStatDto> list2 = Objects.requireNonNull(list, "selectedApps");
        if (this.selectedApps == list2) {
            return this;
        }
        return new ImmutableHistoricalDpiQueryParameters(list2, this.selectedClientMacs);
    }

    public final ImmutableHistoricalDpiQueryParameters withSelectedApps(Optional<? extends List<DpiStatDto>> optional) {
        List list = optional.orElse(null);
        if (this.selectedApps == list) {
            return this;
        }
        return new ImmutableHistoricalDpiQueryParameters(list, this.selectedClientMacs);
    }

    public final ImmutableHistoricalDpiQueryParameters withSelectedClientMacs(List<String> list) {
        List<String> list2 = Objects.requireNonNull(list, "selectedClientMacs");
        if (this.selectedClientMacs == list2) {
            return this;
        }
        return new ImmutableHistoricalDpiQueryParameters(this.selectedApps, list2);
    }

    public final ImmutableHistoricalDpiQueryParameters withSelectedClientMacs(Optional<? extends List<String>> optional) {
        List list = optional.orElse(null);
        if (this.selectedClientMacs == list) {
            return this;
        }
        return new ImmutableHistoricalDpiQueryParameters(this.selectedApps, list);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableHistoricalDpiQueryParameters && this.super(0, (ImmutableHistoricalDpiQueryParameters)object);
    }

    private boolean super(int n2, ImmutableHistoricalDpiQueryParameters immutableHistoricalDpiQueryParameters) {
        return Objects.equals(this.selectedApps, immutableHistoricalDpiQueryParameters.selectedApps) && Objects.equals(this.selectedClientMacs, immutableHistoricalDpiQueryParameters.selectedClientMacs);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.selectedApps);
        n2 += (n2 << 5) + Objects.hashCode(this.selectedClientMacs);
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HistoricalDpiQueryParameters").omitNullValues().add("selectedApps", this.selectedApps).add("selectedClientMacs", this.selectedClientMacs).toString();
    }

    public static ImmutableHistoricalDpiQueryParameters copyOf(HistoricalDpiQueryParameters historicalDpiQueryParameters) {
        if (historicalDpiQueryParameters instanceof ImmutableHistoricalDpiQueryParameters) {
            return (ImmutableHistoricalDpiQueryParameters)historicalDpiQueryParameters;
        }
        return ImmutableHistoricalDpiQueryParameters.builder().from(historicalDpiQueryParameters).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HistoricalDpiQueryParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private List<DpiStatDto> selectedApps;
        @Nullable
        private List<String> selectedClientMacs;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HistoricalDpiQueryParameters historicalDpiQueryParameters) {
            Optional<List<String>> optional;
            Objects.requireNonNull(historicalDpiQueryParameters, "instance");
            Optional<List<DpiStatDto>> optional2 = historicalDpiQueryParameters.selectedApps();
            if (optional2.isPresent()) {
                this.selectedApps(optional2);
            }
            if ((optional = historicalDpiQueryParameters.selectedClientMacs()).isPresent()) {
                this.selectedClientMacs(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selectedApps(List<DpiStatDto> list) {
            this.selectedApps = Objects.requireNonNull(list, "selectedApps");
            return this;
        }

        @JsonProperty(value="apps")
        @CanIgnoreReturnValue
        public final Builder selectedApps(Optional<? extends List<DpiStatDto>> optional) {
            this.selectedApps = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selectedClientMacs(List<String> list) {
            this.selectedClientMacs = Objects.requireNonNull(list, "selectedClientMacs");
            return this;
        }

        @JsonProperty(value="client_macs")
        @CanIgnoreReturnValue
        public final Builder selectedClientMacs(Optional<? extends List<String>> optional) {
            this.selectedClientMacs = optional.orElse(null);
            return this;
        }

        public ImmutableHistoricalDpiQueryParameters build() {
            return new ImmutableHistoricalDpiQueryParameters(this.selectedApps, this.selectedClientMacs);
        }
    }
}

