/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.trafficstats.HistoricalTopAppTrafficUsageDto;
import com.ubnt.model.api.trafficstats.HistoricalTrafficRateDto;
import com.ubnt.model.api.trafficstats.ImmutableHistoricalTrafficUsageDto;
import com.ubnt.ooOO.C;
import java.util.Comparator;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@C
public abstract class HistoricalTrafficUsageDto
implements HistoricalTrafficRateDto,
Comparable<HistoricalTrafficUsageDto> {
    @JsonProperty(value="interval_seconds")
    public abstract long intervalSeconds();

    @JsonProperty(value="total_bytes")
    public abstract long totalBytes();

    @JsonProperty(value="top_app")
    public abstract Optional<HistoricalTopAppTrafficUsageDto> topAppTrafficUsage();

    @Override
    public int compareTo(HistoricalTrafficUsageDto historicalTrafficUsageDto) {
        return Comparator.comparingLong(HistoricalTrafficRateDto::timestamp).compare(this, historicalTrafficUsageDto);
    }

    public static HistoricalTrafficUsageDto createEmptyDto(long l2, long l3) {
        return ImmutableHistoricalTrafficUsageDto.builder().timestamp(l2).intervalSeconds(l3).totalBytes(0L).rxByteRate(0L).txByteRate(0L).topAppTrafficUsage(Optional.empty()).build();
    }
}

