/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficrule;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.traffic.TrafficDomainDto;
import com.ubnt.model.api.traffic.TrafficIpDto;
import com.ubnt.model.api.traffic.TrafficIpRangeDto;
import com.ubnt.model.api.traffic.TrafficTargetDeviceDto;
import com.ubnt.model.api.trafficrule.ImmutableTrafficRuleDto;
import com.ubnt.model.api.trafficrule.TrafficDirection;
import com.ubnt.model.api.trafficrule.TrafficRuleAction;
import com.ubnt.model.api.trafficrule.TrafficRuleBandwidthLimitDto;
import com.ubnt.model.api.trafficrule.TrafficRuleMatchingTarget;
import com.ubnt.model.api.trafficrule.TrafficRuleScheduleDto;
import com.ubnt.ooOO.E;
import com.ubnt.service.trafficrule.TrafficRuleBandwidthLimitDocumentPart;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import com.ubnt.service.trafficrule.TrafficRuleScheduleDocumentPart;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableTrafficRuleDto.class)
@JsonDeserialize(builder=ImmutableTrafficRuleDto.Builder.class)
@Value.Immutable(copy=true)
@E
public interface TrafficRuleDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="description")
    public String description();

    @JsonProperty(value="action")
    @NotNull
    public TrafficRuleAction action();

    @JsonProperty(value="matching_target")
    @NotNull
    public TrafficRuleMatchingTarget matchingTarget();

    @JsonProperty(value="app_category_ids")
    public List<Integer> appCategoryIds();

    @JsonProperty(value="app_ids")
    public List<Integer> appIds();

    @JsonProperty(value="domains")
    @Valid
    public List<TrafficDomainDto> domains();

    @JsonProperty(value="ip_addresses")
    @Valid
    public List<TrafficIpDto> ipAddresses();

    @JsonProperty(value="ip_ranges")
    @Valid
    public List<TrafficIpRangeDto> ipRanges();

    @JsonProperty(value="network_ids")
    public List<String> networkIds();

    @JsonProperty(value="regions")
    @Size(max=150)
    public @Size(max=150) List<String> regions();

    @JsonProperty(value="traffic_direction")
    @ApiModelProperty(value="Traffic direction used for \"Internet\" and \"Local Network\" targets")
    @Valid
    public Optional<TrafficDirection> trafficDirection();

    @JsonProperty(value="target_devices")
    @Valid
    @NotEmpty
    public List<TrafficTargetDeviceDto> targetDevices();

    @JsonProperty(value="schedule")
    @Valid
    public TrafficRuleScheduleDto schedule();

    @JsonProperty(value="bandwidth_limit")
    @Valid
    public TrafficRuleBandwidthLimitDto bandwidthLimit();

    default public TrafficRuleDocument toDocument(String string) {
        TrafficRuleScheduleDto trafficRuleScheduleDto = this.schedule();
        TrafficRuleBandwidthLimitDto trafficRuleBandwidthLimitDto = this.bandwidthLimit();
        return TrafficRuleDocument.builder().interface(this.id()).\u00d300000(string).\u00f600000(this.enabled()).super(this.description()).\u00d2O0000(this.action()).\u00d600000(this.matchingTarget()).supernew(this.appCategoryIds()).\u00f4o0000(this.appIds()).\u00d400000(this.domains().stream().map(TrafficDomainDto::toDocument).collect(Collectors.toList())).\u00f400000(this.ipAddresses().stream().map(TrafficIpDto::toDocument).collect(Collectors.toList())).\u00d6o0000(this.ipRanges().stream().map(TrafficIpRangeDto::toDocument).collect(Collectors.toList())).\u00d3o0000(this.networkIds()).voidsuper(this.regions()).\u00d3\u00d20000(this.trafficDirection().orElse(null)).\u00f800000(this.targetDevices().stream().map(TrafficTargetDeviceDto::toDocument).collect(Collectors.toList())).\u00d6O0000(trafficRuleScheduleDto != null ? trafficRuleScheduleDto.toDocument() : TrafficRuleScheduleDocumentPart.ALWAYS_SCHEDULE).int(trafficRuleBandwidthLimitDto != null ? trafficRuleBandwidthLimitDto.toDocument() : TrafficRuleBandwidthLimitDocumentPart.DISABLED_BANDWIDTH_LIMITING).\u00f8O0000();
    }

    public static ImmutableTrafficRuleDto.Builder builder() {
        return ImmutableTrafficRuleDto.builder();
    }

    public static TrafficRuleDto withId(TrafficRuleDto trafficRuleDto, String string) {
        return ImmutableTrafficRuleDto.copyOf(trafficRuleDto).withId(string);
    }

    public static TrafficRuleDto fromDocument(TrafficRuleDocument trafficRuleDocument) {
        return TrafficRuleDto.builder().id(trafficRuleDocument.getId()).enabled(Optional.ofNullable(trafficRuleDocument.isEnabled()).orElse(false)).description(trafficRuleDocument.getDescription()).action(trafficRuleDocument.getAction()).matchingTarget(trafficRuleDocument.getMatchingTarget()).appCategoryIds(trafficRuleDocument.getAppCategoryIds()).appIds(trafficRuleDocument.getAppIds()).domains(trafficRuleDocument.getDomains().stream().map(TrafficDomainDto::fromDocument).collect(Collectors.toList())).ipAddresses(trafficRuleDocument.getIpAddresses().stream().map(TrafficIpDto::fromDocument).collect(Collectors.toList())).ipRanges(trafficRuleDocument.getIpRanges().stream().map(TrafficIpRangeDto::fromDocument).collect(Collectors.toList())).networkIds(trafficRuleDocument.getNetworkIds()).regions(trafficRuleDocument.getRegions()).trafficDirection(Optional.ofNullable(trafficRuleDocument.getTrafficDirection())).targetDevices(trafficRuleDocument.getTargetDevices().stream().map(TrafficTargetDeviceDto::fromDocument).collect(Collectors.toList())).schedule(TrafficRuleScheduleDto.fromDocument(trafficRuleDocument.getSchedule())).bandwidthLimit(TrafficRuleBandwidthLimitDto.fromDocument(trafficRuleDocument.getBandwidthLimit())).build();
    }
}

