/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.traffic;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.traffic.ImmutableTrafficDomainDto;
import com.ubnt.model.api.traffic.TrafficPortRangeDto;
import com.ubnt.ooOO.E;
import com.ubnt.service.traffic.TrafficDomainDocumentPart;
import com.ubnt.service.traffic.TrafficPortRangeDocumentPart;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableTrafficDomainDto.class)
@JsonDeserialize(builder=ImmutableTrafficDomainDto.Builder.class)
@Value.Immutable
@E
public interface TrafficDomainDto {
    @NotNull
    @JsonProperty(value="domain")
    public String domain();

    @JsonProperty(value="ports")
    public List<@Min(value=1L) @Max(value=65535L) Integer> ports();

    @Valid
    @JsonProperty(value="port_ranges")
    public List<TrafficPortRangeDto> portRanges();

    default public TrafficDomainDocumentPart toDocument() {
        return TrafficDomainDocumentPart.builder().for(this.domain()).String(this.ports()).null(this.portRanges().stream().map(trafficPortRangeDto -> TrafficPortRangeDocumentPart.of(trafficPortRangeDto.portStart(), trafficPortRangeDto.portStop())).collect(Collectors.toList())).\u00d600000();
    }

    public static ImmutableTrafficDomainDto.Builder builder() {
        return ImmutableTrafficDomainDto.builder();
    }

    public static TrafficDomainDto fromDocument(TrafficDomainDocumentPart trafficDomainDocumentPart) {
        return TrafficDomainDto.builder().domain(trafficDomainDocumentPart.getDomain()).ports(trafficDomainDocumentPart.getPorts()).portRanges(trafficDomainDocumentPart.getPortRanges().stream().map(trafficPortRangeDocumentPart -> TrafficPortRangeDto.of(trafficPortRangeDocumentPart.getPortStart(), trafficPortRangeDocumentPart.getPortStop())).collect(Collectors.toList())).build();
    }
}

