/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.speedtest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.data.X;
import com.ubnt.model.api.speedtest.ImmutableSpeedtestDto;
import com.ubnt.ooOO.C;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableSpeedtestDto.class)
@Value.Immutable
@C
public abstract class SpeedtestDto {
    @JsonProperty(value="id")
    public abstract Optional<String> id();

    @JsonProperty(value="download_mbps")
    public abstract long downloadMbps();

    @JsonProperty(value="upload_mbps")
    public abstract long uploadMbps();

    @JsonProperty(value="latency_ms")
    public abstract long latencyMs();

    @JsonProperty(value="time")
    public abstract Long timestamp();

    @JsonProperty(value="interface_name")
    public abstract String interfaceName();

    public static ImmutableSpeedtestDto.Builder builder() {
        return ImmutableSpeedtestDto.builder();
    }

    public static SpeedtestDto fromX(X x2) {
        return SpeedtestDto.builder().id(Optional.ofNullable(x2.getString("_id"))).latencyMs(x2.getLong("latency")).downloadMbps(x2.getLong("xput_download")).uploadMbps(x2.getLong("xput_upload")).timestamp(x2.getLong("time")).interfaceName(x2.getString("interface_name", "")).build();
    }

    public String toCsvRow() {
        return StringUtils.joinWith((String)";", (Object[])new Object[]{this.timestamp(), this.latencyMs(), this.downloadMbps(), this.uploadMbps()});
    }
}

