/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.radius;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.ace.O;
import com.ubnt.data.Account;
import com.ubnt.model.api.radius.ImmutableRadiusUserDto;
import com.ubnt.model.api.radius.RadiusGroupPolicy;
import com.ubnt.model.api.radius.TunnelConfigType;
import com.ubnt.net.v2.config.security.View;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.ooOO.E;
import com.ubnt.service.config.o0oO;
import io.swagger.annotations.ApiModelProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableRadiusUserDto.class)
@JsonDeserialize(as=ImmutableRadiusUserDto.class)
@Value.Immutable(copy=true)
@E
public abstract class RadiusUserDto
implements o0oO {
    private static final int MISSING = -1;

    @JsonProperty(value="_id")
    public abstract Optional<String> getId();

    @JsonIgnore
    @Nullable
    public abstract String getSiteId();

    @JsonProperty(value="name")
    @NotEmpty
    public abstract String getName();

    @JsonProperty(value="x_password")
    @JsonView(value={View.SiteAdmin.class})
    @NotEmpty
    public abstract String getPassword();

    @JsonProperty(value="vlan")
    @ApiModelProperty(value="between 2 and 4009", example="21")
    public abstract Optional<@Min(value=2L) @Max(value=4009L) Integer> getVlan();

    @JsonProperty(value="ip")
    public abstract Optional<@Ip String> getIp();

    @JsonProperty(value="tunnel_config_type")
    public abstract Optional<TunnelConfigType> getTunnelConfigType();

    @JsonProperty(value="tunnel_type")
    public abstract Optional<Integer> getTunnelType();

    @JsonProperty(value="tunnel_medium_type")
    public abstract Optional<Integer> getTunnelMediumType();

    @JsonProperty(value="networkconf_id")
    public abstract Optional<String> networkConfId();

    @JsonProperty(value="group_policy")
    public abstract Optional<RadiusGroupPolicy> getGroupPolicy();

    public static ImmutableRadiusUserDto.Builder builder() {
        return ImmutableRadiusUserDto.builder();
    }

    public static RadiusUserDto fromX(Account account) {
        return ImmutableRadiusUserDto.builder().id(Optional.ofNullable(account.getString("_id"))).siteId(account.getString("site_id")).name(account.getString("name")).password(account.getString("x_password")).ip(Optional.ofNullable(account.getString("ip"))).vlan(RadiusUserDto.super(account.getInt("vlan", -1))).tunnelConfigType(TunnelConfigType.ofNullable(account.getString("tunnel_config_type"))).tunnelType(RadiusUserDto.super(account.getInt("tunnel_type", -1))).tunnelMediumType(RadiusUserDto.super(account.getInt("tunnel_medium_type", -1))).groupPolicy(O.class(RadiusGroupPolicy.class, account.getString("group_policy"))).build();
    }

    public Account toX() {
        Account account = new Account().setName(this.getName()).setPassword(this.getPassword());
        Optional<String> optional = this.getTunnelConfigType().map(TunnelConfigType::toString);
        account.put("site_id", (Object)this.getSiteId());
        account.putIfPresent("_id", this.getId()).putIfPresent("ip", this.getIp()).putIfPresent("vlan", this.getVlan()).putIfPresent("tunnel_config_type", optional).putIfPresent("tunnel_type", this.getTunnelType()).putIfPresent("tunnel_medium_type", this.getTunnelMediumType());
        this.getGroupPolicy().ifPresent(account::setGroupPolicy);
        this.\u00d200000(account);
        return account;
    }

    private void \u00d200000(Account account) {
        this.getGroupPolicy().filter(radiusGroupPolicy -> radiusGroupPolicy == RadiusGroupPolicy.UID).ifPresent(radiusGroupPolicy -> account.put("attr_no_edit", (Object)true));
    }

    private static Optional<Integer> super(int n2) {
        return n2 != -1 ? Optional.of(n2) : Optional.empty();
    }
}

