/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.pingtest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.data.X;
import com.ubnt.model.api.pingtest.ImmutablePingTestReply;
import com.ubnt.ooOO.C;
import io.swagger.annotations.ApiModel;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="Reply of Client Ping Request")
@JsonDeserialize(as=ImmutablePingTestReply.class)
@Value.Immutable
@C
public interface PingTestReply {
    public static final int DEFAULT_TTL = 64;
    public static final double LATENCY_WITHOUT_RESPONSE = -1.0;

    @JsonProperty(value="id")
    public int id();

    @JsonProperty(value="client")
    public Optional<String> client();

    @JsonProperty(value="client_ip")
    public Optional<String> clientIp();

    @JsonProperty(value="time")
    public double time();

    @JsonProperty(value="ttl")
    public Optional<Integer> ttl();

    public static PingTestReply from(String string, X x2) {
        return ImmutablePingTestReply.builder().id(x2.getInt("id")).client(string).clientIp(x2.getString("address")).time(x2.getDouble("time")).ttl(x2.getInt("ttl")).build();
    }

    public static List<PingTestReply> from(String string, List<X> list) {
        return list.stream().map(x2 -> PingTestReply.from(string, x2)).toList();
    }

    public static PingTestReply assignReplyId(PingTestReply pingTestReply, int n2) {
        return ImmutablePingTestReply.builder().id(n2).client(pingTestReply.client()).clientIp(pingTestReply.clientIp()).time(pingTestReply.time()).ttl(pingTestReply.ttl()).build();
    }

    public static PingTestReply missingReplyTemplate(String string, String string2) {
        return ImmutablePingTestReply.builder().client(string).clientIp(string2).ttl(64).time(-1.0).build();
    }
}

