/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.network.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.DhcpOption;
import com.ubnt.model.api.network.configuration.A;
import com.ubnt.model.api.network.configuration.DhcpOptionType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DhcpConfigurationOption {
    @JsonProperty(value="_id")
    @ApiModelProperty(example="5e6285ec05938c3d128aaf07", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String id;
    @JsonProperty(value="name")
    @NotEmpty
    @ApiModelProperty(required=true)
    private String name;
    @JsonProperty(value="type")
    @ApiModelProperty(required=true)
    @NotNull
    private DhcpOptionType type;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="signed")
    private boolean isSigned;

    public String getId() {
        return this.id;
    }

    public DhcpConfigurationOption setId(String string) {
        this.id = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DhcpConfigurationOption setName(String string) {
        this.name = string;
        return this;
    }

    public DhcpOptionType getType() {
        return this.type;
    }

    public DhcpConfigurationOption setType(DhcpOptionType dhcpOptionType) {
        this.type = dhcpOptionType;
        return this;
    }

    public Optional<String> getCode() {
        return Optional.ofNullable(this.code);
    }

    public DhcpConfigurationOption setCode(String string) {
        this.code = string;
        return this;
    }

    public Optional<Integer> getWidth() {
        return Optional.ofNullable(this.width);
    }

    public DhcpConfigurationOption setWidth(Integer n2) {
        this.width = n2;
        return this;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public DhcpConfigurationOption setSigned(boolean bl) {
        this.isSigned = bl;
        return this;
    }

    public static DhcpConfigurationOption fromLegacy(DhcpOption dhcpOption) {
        return A.o00000(dhcpOption);
    }

    public DhcpOption toLegacy() {
        return A.\u00d200000(this);
    }
}

