/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.isp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.alert.AlertListDto;
import com.ubnt.model.api.isp.ConnectionStatusDto;
import com.ubnt.model.api.isp.IspStatusDto;
import com.ubnt.model.api.speedtest.SpeedtestDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IspStatusDto", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableIspStatusDto
implements IspStatusDto {
    private final AlertListDto internetAlerts;
    @Nullable
    private final Long latencyMax;
    private final ConnectionStatusDto uplinkStatus;
    private final ConnectionStatusDto wanStatus;
    private final ConnectionStatusDto wan2Status;
    private final ImmutableList<SpeedtestDto> speedtests;
    private final String pingServer;

    private ImmutableIspStatusDto(AlertListDto alertListDto, @Nullable Long l2, ConnectionStatusDto connectionStatusDto, ConnectionStatusDto connectionStatusDto2, ConnectionStatusDto connectionStatusDto3, ImmutableList<SpeedtestDto> immutableList, String string) {
        this.internetAlerts = alertListDto;
        this.latencyMax = l2;
        this.uplinkStatus = connectionStatusDto;
        this.wanStatus = connectionStatusDto2;
        this.wan2Status = connectionStatusDto3;
        this.speedtests = immutableList;
        this.pingServer = string;
    }

    @Override
    @JsonProperty(value="internet_alerts")
    public AlertListDto internetAlerts() {
        return this.internetAlerts;
    }

    @Override
    @JsonProperty(value="latency_max")
    public Optional<Long> latencyMax() {
        return Optional.ofNullable(this.latencyMax);
    }

    @Override
    @JsonProperty(value="uplink_status")
    public ConnectionStatusDto uplinkStatus() {
        return this.uplinkStatus;
    }

    @Override
    @JsonProperty(value="wan_status")
    public ConnectionStatusDto wanStatus() {
        return this.wanStatus;
    }

    @Override
    @JsonProperty(value="wan2_status")
    public ConnectionStatusDto wan2Status() {
        return this.wan2Status;
    }

    @JsonProperty(value="speedtest_historical")
    public ImmutableList<SpeedtestDto> speedtests() {
        return this.speedtests;
    }

    @Override
    @JsonProperty(value="ping_server")
    public String pingServer() {
        return this.pingServer;
    }

    public final ImmutableIspStatusDto withInternetAlerts(AlertListDto alertListDto) {
        if (this.internetAlerts == alertListDto) {
            return this;
        }
        AlertListDto alertListDto2 = Objects.requireNonNull(alertListDto, "internetAlerts");
        return new ImmutableIspStatusDto(alertListDto2, this.latencyMax, this.uplinkStatus, this.wanStatus, this.wan2Status, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withLatencyMax(long l2) {
        Long l3 = l2;
        if (Objects.equals(this.latencyMax, l3)) {
            return this;
        }
        return new ImmutableIspStatusDto(this.internetAlerts, l3, this.uplinkStatus, this.wanStatus, this.wan2Status, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withLatencyMax(Optional<Long> optional) {
        Long l2 = optional.orElse(null);
        if (Objects.equals(this.latencyMax, l2)) {
            return this;
        }
        return new ImmutableIspStatusDto(this.internetAlerts, l2, this.uplinkStatus, this.wanStatus, this.wan2Status, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withUplinkStatus(ConnectionStatusDto connectionStatusDto) {
        if (this.uplinkStatus == connectionStatusDto) {
            return this;
        }
        ConnectionStatusDto connectionStatusDto2 = Objects.requireNonNull(connectionStatusDto, "uplinkStatus");
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, connectionStatusDto2, this.wanStatus, this.wan2Status, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withWanStatus(ConnectionStatusDto connectionStatusDto) {
        if (this.wanStatus == connectionStatusDto) {
            return this;
        }
        ConnectionStatusDto connectionStatusDto2 = Objects.requireNonNull(connectionStatusDto, "wanStatus");
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, connectionStatusDto2, this.wan2Status, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withWan2Status(ConnectionStatusDto connectionStatusDto) {
        if (this.wan2Status == connectionStatusDto) {
            return this;
        }
        ConnectionStatusDto connectionStatusDto2 = Objects.requireNonNull(connectionStatusDto, "wan2Status");
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, this.wanStatus, connectionStatusDto2, this.speedtests, this.pingServer);
    }

    public final ImmutableIspStatusDto withSpeedtests(SpeedtestDto ... speedtestDtoArray) {
        ImmutableList immutableList = ImmutableList.copyOf((Object[])speedtestDtoArray);
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, this.wanStatus, this.wan2Status, (ImmutableList<SpeedtestDto>)immutableList, this.pingServer);
    }

    public final ImmutableIspStatusDto withSpeedtests(Iterable<? extends SpeedtestDto> iterable) {
        if (this.speedtests == iterable) {
            return this;
        }
        ImmutableList immutableList = ImmutableList.copyOf(iterable);
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, this.wanStatus, this.wan2Status, (ImmutableList<SpeedtestDto>)immutableList, this.pingServer);
    }

    public final ImmutableIspStatusDto withPingServer(String string) {
        String string2 = Objects.requireNonNull(string, "pingServer");
        if (this.pingServer.equals(string2)) {
            return this;
        }
        return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, this.wanStatus, this.wan2Status, this.speedtests, string2);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableIspStatusDto && this.o00000(0, (ImmutableIspStatusDto)object);
    }

    private boolean o00000(int n2, ImmutableIspStatusDto immutableIspStatusDto) {
        return this.internetAlerts.equals(immutableIspStatusDto.internetAlerts) && Objects.equals(this.latencyMax, immutableIspStatusDto.latencyMax) && this.uplinkStatus.equals(immutableIspStatusDto.uplinkStatus) && this.wanStatus.equals(immutableIspStatusDto.wanStatus) && this.wan2Status.equals(immutableIspStatusDto.wan2Status) && this.speedtests.equals(immutableIspStatusDto.speedtests) && this.pingServer.equals(immutableIspStatusDto.pingServer);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.internetAlerts.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.latencyMax);
        n2 += (n2 << 5) + this.uplinkStatus.hashCode();
        n2 += (n2 << 5) + this.wanStatus.hashCode();
        n2 += (n2 << 5) + this.wan2Status.hashCode();
        n2 += (n2 << 5) + this.speedtests.hashCode();
        n2 += (n2 << 5) + this.pingServer.hashCode();
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IspStatusDto").omitNullValues().add("internetAlerts", (Object)this.internetAlerts).add("latencyMax", (Object)this.latencyMax).add("uplinkStatus", (Object)this.uplinkStatus).add("wanStatus", (Object)this.wanStatus).add("wan2Status", (Object)this.wan2Status).add("speedtests", this.speedtests).add("pingServer", (Object)this.pingServer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIspStatusDto \u00d200000(_o _o2) {
        Builder builder = ImmutableIspStatusDto.builder();
        if (_o2.new != null) {
            builder.internetAlerts(_o2.new);
        }
        if (_o2.\u00d500000 != null) {
            builder.latencyMax(_o2.\u00d500000);
        }
        if (_o2.\u00d800000 != null) {
            builder.uplinkStatus(_o2.\u00d800000);
        }
        if (_o2.\u00d300000 != null) {
            builder.wanStatus(_o2.\u00d300000);
        }
        if (_o2.return != null) {
            builder.wan2Status(_o2.return);
        }
        if (_o2.\u00d400000 != null) {
            builder.addAllSpeedtests(_o2.\u00d400000);
        }
        if (_o2.o00000 != null) {
            builder.pingServer(_o2.o00000);
        }
        return builder.build();
    }

    public static ImmutableIspStatusDto copyOf(IspStatusDto ispStatusDto) {
        if (ispStatusDto instanceof ImmutableIspStatusDto) {
            return (ImmutableIspStatusDto)ispStatusDto;
        }
        return ImmutableIspStatusDto.builder().from(ispStatusDto).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IspStatusDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INTERNET_ALERTS = 1L;
        private static final long INIT_BIT_UPLINK_STATUS = 2L;
        private static final long INIT_BIT_WAN_STATUS = 4L;
        private static final long INIT_BIT_WAN2_STATUS = 8L;
        private static final long INIT_BIT_PING_SERVER = 16L;
        private long initBits = 31L;
        @Nullable
        private AlertListDto internetAlerts;
        @Nullable
        private Long latencyMax;
        @Nullable
        private ConnectionStatusDto uplinkStatus;
        @Nullable
        private ConnectionStatusDto wanStatus;
        @Nullable
        private ConnectionStatusDto wan2Status;
        private ImmutableList.Builder<SpeedtestDto> speedtests = ImmutableList.builder();
        @Nullable
        private String pingServer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IspStatusDto ispStatusDto) {
            Objects.requireNonNull(ispStatusDto, "instance");
            this.internetAlerts(ispStatusDto.internetAlerts());
            Optional<Long> optional = ispStatusDto.latencyMax();
            if (optional.isPresent()) {
                this.latencyMax(optional);
            }
            this.uplinkStatus(ispStatusDto.uplinkStatus());
            this.wanStatus(ispStatusDto.wanStatus());
            this.wan2Status(ispStatusDto.wan2Status());
            this.addAllSpeedtests(ispStatusDto.speedtests());
            this.pingServer(ispStatusDto.pingServer());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder internetAlerts(AlertListDto alertListDto) {
            this.internetAlerts = Objects.requireNonNull(alertListDto, "internetAlerts");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder latencyMax(long l2) {
            this.latencyMax = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder latencyMax(Optional<Long> optional) {
            this.latencyMax = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uplinkStatus(ConnectionStatusDto connectionStatusDto) {
            this.uplinkStatus = Objects.requireNonNull(connectionStatusDto, "uplinkStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wanStatus(ConnectionStatusDto connectionStatusDto) {
            this.wanStatus = Objects.requireNonNull(connectionStatusDto, "wanStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wan2Status(ConnectionStatusDto connectionStatusDto) {
            this.wan2Status = Objects.requireNonNull(connectionStatusDto, "wan2Status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSpeedtests(SpeedtestDto speedtestDto) {
            this.speedtests.add((Object)speedtestDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSpeedtests(SpeedtestDto ... speedtestDtoArray) {
            this.speedtests.add((Object[])speedtestDtoArray);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder speedtests(Iterable<? extends SpeedtestDto> iterable) {
            this.speedtests = ImmutableList.builder();
            return this.addAllSpeedtests(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSpeedtests(Iterable<? extends SpeedtestDto> iterable) {
            this.speedtests.addAll(iterable);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pingServer(String string) {
            this.pingServer = Objects.requireNonNull(string, "pingServer");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableIspStatusDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.o00000());
            }
            return new ImmutableIspStatusDto(this.internetAlerts, this.latencyMax, this.uplinkStatus, this.wanStatus, this.wan2Status, (ImmutableList<SpeedtestDto>)this.speedtests.build(), this.pingServer);
        }

        private String o00000() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("internetAlerts");
            }
            if ((this.initBits & 2L) != 0L) {
                arrayList.add("uplinkStatus");
            }
            if ((this.initBits & 4L) != 0L) {
                arrayList.add("wanStatus");
            }
            if ((this.initBits & 8L) != 0L) {
                arrayList.add("wan2Status");
            }
            if ((this.initBits & 0x10L) != 0L) {
                arrayList.add("pingServer");
            }
            return "Cannot build IspStatusDto, some of required attributes are not set " + arrayList;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IspStatusDto", generator="Immutables")
    static final class _o
    implements IspStatusDto {
        @Nullable
        AlertListDto new;
        @Nullable
        Optional<Long> \u00d500000 = Optional.empty();
        @Nullable
        ConnectionStatusDto \u00d800000;
        @Nullable
        ConnectionStatusDto \u00d300000;
        @Nullable
        ConnectionStatusDto return;
        @Nullable
        List<SpeedtestDto> \u00d400000 = ImmutableList.of();
        @Nullable
        String o00000;

        _o() {
        }

        @JsonProperty(value="internet_alerts")
        public void Object(AlertListDto alertListDto) {
            this.new = alertListDto;
        }

        @JsonProperty(value="latency_max")
        public void \u00d400000(Optional<Long> optional) {
            this.\u00d500000 = optional;
        }

        @JsonProperty(value="uplink_status")
        public void \u00f500000(ConnectionStatusDto connectionStatusDto) {
            this.\u00d800000 = connectionStatusDto;
        }

        @JsonProperty(value="wan_status")
        public void \u00d600000(ConnectionStatusDto connectionStatusDto) {
            this.\u00d300000 = connectionStatusDto;
        }

        @JsonProperty(value="wan2_status")
        public void \u00f400000(ConnectionStatusDto connectionStatusDto) {
            this.return = connectionStatusDto;
        }

        @JsonProperty(value="speedtest_historical")
        public void void(List<SpeedtestDto> list) {
            this.\u00d400000 = list;
        }

        @JsonProperty(value="ping_server")
        public void \u00d500000(String string) {
            this.o00000 = string;
        }

        @Override
        public AlertListDto internetAlerts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> latencyMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectionStatusDto uplinkStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectionStatusDto wanStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectionStatusDto wan2Status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SpeedtestDto> speedtests() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String pingServer() {
            throw new UnsupportedOperationException();
        }
    }
}

