/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.isp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.isp.ConnectionStatisticsDto;
import com.ubnt.model.api.isp.ConnectionStatusDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConnectionStatusDto", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConnectionStatusDto
implements ConnectionStatusDto {
    private final ImmutableList<ConnectionStatisticsDto> connectionStatistics;
    private final long receivedBytesTotal;
    private final long transmittedBytesTotal;
    private final long latencyThreshold;

    private ImmutableConnectionStatusDto(ImmutableList<ConnectionStatisticsDto> immutableList, long l2, long l3, long l4) {
        this.connectionStatistics = immutableList;
        this.receivedBytesTotal = l2;
        this.transmittedBytesTotal = l3;
        this.latencyThreshold = l4;
    }

    @JsonProperty(value="statistics")
    public ImmutableList<ConnectionStatisticsDto> connectionStatistics() {
        return this.connectionStatistics;
    }

    @Override
    @JsonProperty(value="received_bytes")
    public long receivedBytesTotal() {
        return this.receivedBytesTotal;
    }

    @Override
    @JsonProperty(value="transmitted_bytes")
    public long transmittedBytesTotal() {
        return this.transmittedBytesTotal;
    }

    @Override
    @JsonProperty(value="latency_threshold")
    public long latencyThreshold() {
        return this.latencyThreshold;
    }

    public final ImmutableConnectionStatusDto withConnectionStatistics(ConnectionStatisticsDto ... connectionStatisticsDtoArray) {
        ImmutableList immutableList = ImmutableList.copyOf((Object[])connectionStatisticsDtoArray);
        return new ImmutableConnectionStatusDto((ImmutableList<ConnectionStatisticsDto>)immutableList, this.receivedBytesTotal, this.transmittedBytesTotal, this.latencyThreshold);
    }

    public final ImmutableConnectionStatusDto withConnectionStatistics(Iterable<? extends ConnectionStatisticsDto> iterable) {
        if (this.connectionStatistics == iterable) {
            return this;
        }
        ImmutableList immutableList = ImmutableList.copyOf(iterable);
        return new ImmutableConnectionStatusDto((ImmutableList<ConnectionStatisticsDto>)immutableList, this.receivedBytesTotal, this.transmittedBytesTotal, this.latencyThreshold);
    }

    public final ImmutableConnectionStatusDto withReceivedBytesTotal(long l2) {
        if (this.receivedBytesTotal == l2) {
            return this;
        }
        return new ImmutableConnectionStatusDto(this.connectionStatistics, l2, this.transmittedBytesTotal, this.latencyThreshold);
    }

    public final ImmutableConnectionStatusDto withTransmittedBytesTotal(long l2) {
        if (this.transmittedBytesTotal == l2) {
            return this;
        }
        return new ImmutableConnectionStatusDto(this.connectionStatistics, this.receivedBytesTotal, l2, this.latencyThreshold);
    }

    public final ImmutableConnectionStatusDto withLatencyThreshold(long l2) {
        if (this.latencyThreshold == l2) {
            return this;
        }
        return new ImmutableConnectionStatusDto(this.connectionStatistics, this.receivedBytesTotal, this.transmittedBytesTotal, l2);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableConnectionStatusDto && this.\u00d600000(0, (ImmutableConnectionStatusDto)object);
    }

    private boolean \u00d600000(int n2, ImmutableConnectionStatusDto immutableConnectionStatusDto) {
        return this.connectionStatistics.equals(immutableConnectionStatusDto.connectionStatistics) && this.receivedBytesTotal == immutableConnectionStatusDto.receivedBytesTotal && this.transmittedBytesTotal == immutableConnectionStatusDto.transmittedBytesTotal && this.latencyThreshold == immutableConnectionStatusDto.latencyThreshold;
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.connectionStatistics.hashCode();
        n2 += (n2 << 5) + Longs.hashCode((long)this.receivedBytesTotal);
        n2 += (n2 << 5) + Longs.hashCode((long)this.transmittedBytesTotal);
        n2 += (n2 << 5) + Longs.hashCode((long)this.latencyThreshold);
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectionStatusDto").omitNullValues().add("connectionStatistics", this.connectionStatistics).add("receivedBytesTotal", this.receivedBytesTotal).add("transmittedBytesTotal", this.transmittedBytesTotal).add("latencyThreshold", this.latencyThreshold).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConnectionStatusDto \u00d500000(_o _o2) {
        Builder builder = ImmutableConnectionStatusDto.builder();
        if (_o2.return != null) {
            builder.addAllConnectionStatistics(_o2.return);
        }
        if (_o2.new) {
            builder.receivedBytesTotal(_o2.\u00d800000);
        }
        if (_o2.o00000) {
            builder.transmittedBytesTotal(_o2.\u00d400000);
        }
        if (_o2.\u00d300000) {
            builder.latencyThreshold(_o2.\u00d500000);
        }
        return builder.build();
    }

    public static ImmutableConnectionStatusDto copyOf(ConnectionStatusDto connectionStatusDto) {
        if (connectionStatusDto instanceof ImmutableConnectionStatusDto) {
            return (ImmutableConnectionStatusDto)connectionStatusDto;
        }
        return ImmutableConnectionStatusDto.builder().from(connectionStatusDto).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectionStatusDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RECEIVED_BYTES_TOTAL = 1L;
        private static final long INIT_BIT_TRANSMITTED_BYTES_TOTAL = 2L;
        private static final long INIT_BIT_LATENCY_THRESHOLD = 4L;
        private long initBits = 7L;
        private ImmutableList.Builder<ConnectionStatisticsDto> connectionStatistics = ImmutableList.builder();
        private long receivedBytesTotal;
        private long transmittedBytesTotal;
        private long latencyThreshold;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectionStatusDto connectionStatusDto) {
            Objects.requireNonNull(connectionStatusDto, "instance");
            this.addAllConnectionStatistics(connectionStatusDto.connectionStatistics());
            this.receivedBytesTotal(connectionStatusDto.receivedBytesTotal());
            this.transmittedBytesTotal(connectionStatusDto.transmittedBytesTotal());
            this.latencyThreshold(connectionStatusDto.latencyThreshold());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConnectionStatistics(ConnectionStatisticsDto connectionStatisticsDto) {
            this.connectionStatistics.add((Object)connectionStatisticsDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConnectionStatistics(ConnectionStatisticsDto ... connectionStatisticsDtoArray) {
            this.connectionStatistics.add((Object[])connectionStatisticsDtoArray);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionStatistics(Iterable<? extends ConnectionStatisticsDto> iterable) {
            this.connectionStatistics = ImmutableList.builder();
            return this.addAllConnectionStatistics(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConnectionStatistics(Iterable<? extends ConnectionStatisticsDto> iterable) {
            this.connectionStatistics.addAll(iterable);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder receivedBytesTotal(long l2) {
            this.receivedBytesTotal = l2;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transmittedBytesTotal(long l2) {
            this.transmittedBytesTotal = l2;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder latencyThreshold(long l2) {
            this.latencyThreshold = l2;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableConnectionStatusDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.o00000());
            }
            return new ImmutableConnectionStatusDto((ImmutableList<ConnectionStatisticsDto>)this.connectionStatistics.build(), this.receivedBytesTotal, this.transmittedBytesTotal, this.latencyThreshold);
        }

        private String o00000() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("receivedBytesTotal");
            }
            if ((this.initBits & 2L) != 0L) {
                arrayList.add("transmittedBytesTotal");
            }
            if ((this.initBits & 4L) != 0L) {
                arrayList.add("latencyThreshold");
            }
            return "Cannot build ConnectionStatusDto, some of required attributes are not set " + arrayList;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConnectionStatusDto", generator="Immutables")
    static final class _o
    implements ConnectionStatusDto {
        @Nullable
        List<ConnectionStatisticsDto> return = ImmutableList.of();
        long \u00d800000;
        boolean new;
        long \u00d400000;
        boolean o00000;
        long \u00d500000;
        boolean \u00d300000;

        _o() {
        }

        @JsonProperty(value="statistics")
        public void Object(List<ConnectionStatisticsDto> list) {
            this.return = list;
        }

        @JsonProperty(value="received_bytes")
        public void \u00d400000(long l2) {
            this.\u00d800000 = l2;
            this.new = true;
        }

        @JsonProperty(value="transmitted_bytes")
        public void \u00d200000(long l2) {
            this.\u00d400000 = l2;
            this.o00000 = true;
        }

        @JsonProperty(value="latency_threshold")
        public void o00000(long l2) {
            this.\u00d500000 = l2;
            this.\u00d300000 = true;
        }

        @Override
        public List<ConnectionStatisticsDto> connectionStatistics() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long receivedBytesTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transmittedBytesTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long latencyThreshold() {
            throw new UnsupportedOperationException();
        }
    }
}

