/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dpi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.dpi.ImmutableByAppDpiStatPartDto;
import com.ubnt.service.stat.dpi.ByAppDpiStatDocumentPart;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableByAppDpiStatPartDto.class)
@Value.Immutable
public abstract class ByAppDpiStatPartDto
implements Comparable<ByAppDpiStatPartDto> {
    @JsonProperty(value="application")
    public abstract int application();

    @JsonProperty(value="category")
    public abstract int category();

    @JsonProperty(value="bytes_received")
    public abstract long bytesReceived();

    @JsonProperty(value="bytes_transmitted")
    public abstract long bytesTransmitted();

    @JsonProperty(value="packets_received")
    public abstract long packetsReceived();

    @JsonProperty(value="packets_transmitted")
    public abstract long packetsTransmitted();

    @JsonIgnore
    @Value.Auxiliary
    public long totalBytes() {
        return this.bytesReceived() + this.bytesTransmitted();
    }

    public static ImmutableByAppDpiStatPartDto.Builder builder() {
        return ImmutableByAppDpiStatPartDto.builder();
    }

    public static ByAppDpiStatPartDto fromDocument(ByAppDpiStatDocumentPart byAppDpiStatDocumentPart) {
        return ByAppDpiStatPartDto.builder().application(byAppDpiStatDocumentPart.getApplication()).category(byAppDpiStatDocumentPart.getCategory()).bytesReceived(byAppDpiStatDocumentPart.getBytesReceived()).bytesTransmitted(byAppDpiStatDocumentPart.getBytesTransmitted()).packetsReceived(byAppDpiStatDocumentPart.getPacketsReceived()).packetsTransmitted(byAppDpiStatDocumentPart.getPacketsTransmitted()).build();
    }

    @Override
    public int compareTo(@Nonnull ByAppDpiStatPartDto byAppDpiStatPartDto) {
        return Comparator.comparingLong(ByAppDpiStatPartDto::totalBytes).thenComparingInt(ByAppDpiStatPartDto::application).thenComparingInt(ByAppDpiStatPartDto::category).compare(this, byAppDpiStatPartDto);
    }
}

