/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dpi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.dpi.DpiDto;
import com.ubnt.model.api.dpi.ImmutableAggregatedDpiDto;
import com.ubnt.service.stat.dpi.B;
import com.ubnt.service.stat.dpi.DpiDocument;
import io.swagger.annotations.ApiModelProperty;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableAggregatedDpiDto.class)
@Value.Immutable
public abstract class AggregatedDpiDto {
    @JsonProperty(value="id")
    @ApiModelProperty(value="Autogenerated ID")
    public abstract Optional<String> id();

    @JsonProperty(value="stat_object_id")
    @ApiModelProperty(value="Client/site stat object ID")
    public abstract String statObjectId();

    @JsonProperty(value="first")
    @ApiModelProperty(value="First DPI object returned in aggregation")
    public abstract DpiDto first();

    @JsonProperty(value="last")
    @ApiModelProperty(value="Last DPI object returned in aggregation")
    public abstract DpiDto last();

    public static ImmutableAggregatedDpiDto.Builder builder() {
        return ImmutableAggregatedDpiDto.builder();
    }

    public static AggregatedDpiDto fromDocument(B b2) {
        DpiDocument dpiDocument = b2.new();
        return AggregatedDpiDto.builder().id(Optional.ofNullable(b2.\u00d400000())).statObjectId(dpiDocument.getStatObjectId()).first(DpiDto.fromDocument(dpiDocument)).last(DpiDto.fromDocument(b2.return())).build();
    }
}

