/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard.widgets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.dashboard.NetworkActivityDto;
import com.ubnt.model.api.dashboard.widgets.ImmutableNetworkActivityWidgetDto;
import com.ubnt.model.api.dashboard.widgets.NoStatsReason;
import com.ubnt.ooOO.C;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@C
public interface NetworkActivityWidgetDto {
    @JsonProperty(value="history")
    public List<NetworkActivityDto> activityHistory();

    @JsonProperty(value="num_sta")
    public Optional<Integer> totalClientCount();

    @JsonProperty(value="rx_bytes")
    public Optional<Long> receivedBytes();

    @JsonProperty(value="tx_bytes")
    public Optional<Long> transmittedBytes();

    @JsonProperty(value="no_stats_reason")
    public Optional<NoStatsReason> noStatsReason();

    public static NetworkActivityWidgetDto of(List<NetworkActivityDto> list, int n2) {
        long l2 = list.stream().mapToLong(NetworkActivityDto::rxBytes).sum();
        long l3 = list.stream().mapToLong(NetworkActivityDto::txBytes).sum();
        return ImmutableNetworkActivityWidgetDto.builder().activityHistory(list).totalClientCount(n2).receivedBytes(l2).transmittedBytes(l3).build();
    }

    public static NetworkActivityWidgetDto withoutStats(NoStatsReason noStatsReason) {
        return ImmutableNetworkActivityWidgetDto.builder().activityHistory(List.of()).noStatsReason(noStatsReason).build();
    }
}

