/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.ubnt.model.api.dashboard.ActiveApDto;
import com.ubnt.model.api.dashboard.ImmutableWifiStats;
import com.ubnt.model.api.dashboard.WifiActivityStatDto;
import com.ubnt.model.api.dashboard.WifiExperienceStatDto;
import com.ubnt.model.api.dashboard.WifiTechnologyStatsDto;
import com.ubnt.model.api.dashboard.widgets.WifiClientExperienceCategoryStatDto;
import com.ubnt.model.api.dashboard.widgets.WifiRadioTxRetryStatDto;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface WifiStats {
    @Nullable
    public List<WifiExperienceStatDto> wifiExperienceStats();

    @Nullable
    public List<WifiActivityStatDto> wifiActivityStats();

    @Nullable
    public List<ActiveApDto> mostActiveAps();

    @Nullable
    public BigInteger totalApBytes();

    @Nullable
    public Integer totalApCount();

    @Nullable
    public List<WifiTechnologyStatsDto> wifiTechnologyStats();

    @Nullable
    public List<WifiClientExperienceCategoryStatDto> wifiExperienceCategoryStats();

    @Nullable
    public WifiRadioTxRetryStatDto apTxRetryStats();

    @Value.Default
    default public boolean failedToLoad() {
        return false;
    }

    default public boolean hasWifiExperienceStats() {
        return Optional.ofNullable(this.wifiExperienceStats()).map(list -> list.stream().anyMatch(WifiExperienceStatDto::hasStats)).orElse(false);
    }

    default public boolean hasWifiActivityStats() {
        return Optional.ofNullable(this.wifiActivityStats()).map(list -> list.stream().anyMatch(WifiActivityStatDto::hasStats)).orElse(false);
    }

    public static WifiStats empty() {
        return ImmutableWifiStats.builder().wifiExperienceStats(Collections.emptyList()).wifiActivityStats(Collections.emptyList()).mostActiveAps(Collections.emptyList()).totalApBytes(BigInteger.ZERO).wifiTechnologyStats(Collections.emptyList()).wifiExperienceCategoryStats(Collections.emptyList()).failedToLoad(true).build();
    }
}

