/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.backup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.backup.BackupAndRestoreParameters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="BackupAndRestoreParameters", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableBackupAndRestoreParameters
implements BackupAndRestoreParameters {
    private final String directory;
    @Nullable
    private final Boolean includeFullData;
    @Nullable
    private final Boolean skipWanConfigurationRestore;

    private ImmutableBackupAndRestoreParameters(String string, @Nullable Boolean bl, @Nullable Boolean bl2) {
        this.directory = string;
        this.includeFullData = bl;
        this.skipWanConfigurationRestore = bl2;
    }

    @Override
    @JsonProperty(value="dir")
    public String directory() {
        return this.directory;
    }

    @Override
    @JsonProperty(value="includeFullData")
    public Optional<Boolean> includeFullData() {
        return Optional.ofNullable(this.includeFullData);
    }

    @Override
    @JsonProperty(value="skipWanConfigurationRestore")
    public Optional<Boolean> skipWanConfigurationRestore() {
        return Optional.ofNullable(this.skipWanConfigurationRestore);
    }

    public final ImmutableBackupAndRestoreParameters withDirectory(String string) {
        String string2 = Objects.requireNonNull(string, "directory");
        if (this.directory.equals(string2)) {
            return this;
        }
        return new ImmutableBackupAndRestoreParameters(string2, this.includeFullData, this.skipWanConfigurationRestore);
    }

    public final ImmutableBackupAndRestoreParameters withIncludeFullData(boolean bl) {
        Boolean bl2 = bl;
        if (Objects.equals(this.includeFullData, bl2)) {
            return this;
        }
        return new ImmutableBackupAndRestoreParameters(this.directory, bl2, this.skipWanConfigurationRestore);
    }

    public final ImmutableBackupAndRestoreParameters withIncludeFullData(Optional<Boolean> optional) {
        Boolean bl = optional.orElse(null);
        if (Objects.equals(this.includeFullData, bl)) {
            return this;
        }
        return new ImmutableBackupAndRestoreParameters(this.directory, bl, this.skipWanConfigurationRestore);
    }

    public final ImmutableBackupAndRestoreParameters withSkipWanConfigurationRestore(boolean bl) {
        Boolean bl2 = bl;
        if (Objects.equals(this.skipWanConfigurationRestore, bl2)) {
            return this;
        }
        return new ImmutableBackupAndRestoreParameters(this.directory, this.includeFullData, bl2);
    }

    public final ImmutableBackupAndRestoreParameters withSkipWanConfigurationRestore(Optional<Boolean> optional) {
        Boolean bl = optional.orElse(null);
        if (Objects.equals(this.skipWanConfigurationRestore, bl)) {
            return this;
        }
        return new ImmutableBackupAndRestoreParameters(this.directory, this.includeFullData, bl);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableBackupAndRestoreParameters && this.o00000(0, (ImmutableBackupAndRestoreParameters)object);
    }

    private boolean o00000(int n2, ImmutableBackupAndRestoreParameters immutableBackupAndRestoreParameters) {
        return this.directory.equals(immutableBackupAndRestoreParameters.directory) && Objects.equals(this.includeFullData, immutableBackupAndRestoreParameters.includeFullData) && Objects.equals(this.skipWanConfigurationRestore, immutableBackupAndRestoreParameters.skipWanConfigurationRestore);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.directory.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.includeFullData);
        n2 += (n2 << 5) + Objects.hashCode(this.skipWanConfigurationRestore);
        return n2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BackupAndRestoreParameters").omitNullValues().add("directory", (Object)this.directory).add("includeFullData", (Object)this.includeFullData).add("skipWanConfigurationRestore", (Object)this.skipWanConfigurationRestore).toString();
    }

    public static ImmutableBackupAndRestoreParameters copyOf(BackupAndRestoreParameters backupAndRestoreParameters) {
        if (backupAndRestoreParameters instanceof ImmutableBackupAndRestoreParameters) {
            return (ImmutableBackupAndRestoreParameters)backupAndRestoreParameters;
        }
        return ImmutableBackupAndRestoreParameters.builder().from(backupAndRestoreParameters).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="BackupAndRestoreParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DIRECTORY = 1L;
        private long initBits = 1L;
        @Nullable
        private String directory;
        @Nullable
        private Boolean includeFullData;
        @Nullable
        private Boolean skipWanConfigurationRestore;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BackupAndRestoreParameters backupAndRestoreParameters) {
            Optional<Boolean> optional;
            Objects.requireNonNull(backupAndRestoreParameters, "instance");
            this.directory(backupAndRestoreParameters.directory());
            Optional<Boolean> optional2 = backupAndRestoreParameters.includeFullData();
            if (optional2.isPresent()) {
                this.includeFullData(optional2);
            }
            if ((optional = backupAndRestoreParameters.skipWanConfigurationRestore()).isPresent()) {
                this.skipWanConfigurationRestore(optional);
            }
            return this;
        }

        @JsonProperty(value="dir")
        @CanIgnoreReturnValue
        public final Builder directory(String string) {
            this.directory = Objects.requireNonNull(string, "directory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder includeFullData(boolean bl) {
            this.includeFullData = bl;
            return this;
        }

        @JsonProperty(value="includeFullData")
        @CanIgnoreReturnValue
        public final Builder includeFullData(Optional<Boolean> optional) {
            this.includeFullData = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder skipWanConfigurationRestore(boolean bl) {
            this.skipWanConfigurationRestore = bl;
            return this;
        }

        @JsonProperty(value="skipWanConfigurationRestore")
        @CanIgnoreReturnValue
        public final Builder skipWanConfigurationRestore(Optional<Boolean> optional) {
            this.skipWanConfigurationRestore = optional.orElse(null);
            return this;
        }

        public ImmutableBackupAndRestoreParameters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.super());
            }
            return new ImmutableBackupAndRestoreParameters(this.directory, this.includeFullData, this.skipWanConfigurationRestore);
        }

        private String super() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("directory");
            }
            return "Cannot build BackupAndRestoreParameters, some of required attributes are not set " + arrayList;
        }
    }
}

