/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.ubnt.ace.O;
import com.ubnt.ace.view.C;
import com.ubnt.data.ConnectivitySettingDefaults;
import com.ubnt.data.DpiSettingDefaults;
import com.ubnt.data.GuestAccessSettingDefaults;
import com.ubnt.data.IpsSettingDefaults;
import com.ubnt.data.LcmSettingDefaults;
import com.ubnt.data.MgmtSettingDefaults;
import com.ubnt.data.PortalFile;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.RadiusSettingDefaults;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.SuperMgmtSettingDefaults;
import com.ubnt.data.UsgSettingDefaults;
import com.ubnt.data.X;
import com.ubnt.data.ooOO;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.repository.M;
import com.ubnt.service.Object;
import com.ubnt.service.mail.D;
import com.ubnt.service.network.W;
import com.ubnt.service.system.bA;
import com.ubnt.service.system.ooOOo;
import com.ubnt.service.system.setting.if;
import com.ubnt.service.system.setting.null;
import com.ubnt.service.systemlog.admin.activity.changes.A;
import com.ubnt.service.systemlog.admin.activity.changes.N;
import com.ubnt.service.systemlog.admin.activity.changes.OOoo;
import com.ubnt.service.systemlog.admin.activity.changes.V;
import com.ubnt.service.systemlog.admin.activity.changes.oO0O;
import com.ubnt.service.systemlog.admin.activity.changes.private;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.FileCopyUtils;

public class Setting
extends X
implements Sanitizable,
M,
V,
W {
    private static final Set<String> \u00d3\u00d8\u00d4000 = Set.of("key");
    private static final Map<null, Set<String>> \u00d6\u00f4\u00d4000 = Map.of(null.oO0000, Set.of("x_mesh_essid", "x_mesh_psk"), null.\u00d8O0000, Set.of("x_element_essid", "x_element_psk"), null.oo0000, Set.of("last_alert_id", "last_honeypot_id", ooOOo.class("honeypot", "version")), null.\u00d600000, Set.of("x_api_token", "x_mgmt_key"), null.\u00d3o0000, Set.of("x_pregenerated_dh_key"), null.\u00d200000, Set.of(ooOOo.class("network_overrides", "key"), ooOOo.class("speed_overrides", "key")));
    private static final Map<if, Set<String>> \u00d3\u00f4\u00d4000 = Map.of(if.new, Set.of("device_id", "device_auth", "ubic_uuid", "x_private_key", "x_certificate_arn", "x_certificate_pem"), if.\u00d300000, Set.of("fingerbank_key"), if.if, Set.of("allowed_controller_channels", "allowed_firmware_channels", "available_controller_channels", "available_firmware_channels", "x_sso_token"));
    private static final Map<null, Map<String, OOoo>> \u00f5\u00d8\u00d4000 = Map.of(null.\u00f800000, Map.of("code", OOoo.\u00f6O0000), null.oo0000, Map.of("enabled_networks", OOoo.\u00f5O0000, ooOOo.class("ad_blocking_configurations", "network_id"), OOoo.\u00f5O0000, ooOOo.class("dns_filters", "network_id"), OOoo.\u00f5O0000, ooOOo.class("honeypot", "network_id"), OOoo.\u00f5O0000), null.private, Map.of("dot1x_fallback_networkconf_id", OOoo.\u00f5O0000, "radiusprofile_id", OOoo.\u00d600000), null.\u00f5O0000, Map.of("geo_ip_filtering_countries", OOoo.OO0000), null.\u00d200000, Map.of(ooOOo.class("network_overrides", "key"), OOoo.\u00f5O0000));
    private static final Map<null, Map<String, String>> \u00d8\u00f4\u00d4000 = Map.of(null.oo0000, Map.of("ad_blocking_configurations", "network_id", "dns_filters", "network_id", "honeypot", "network_id", ooOOo.class("suppression", "whitelist"), "value"), null.\u00d200000, Map.of("network_overrides", "key", "speed_overrides", "key"));
    private static final Map<null, Map<String, java.lang.Object>> newdonew = Map.of(null.oO0000, ConnectivitySettingDefaults.getDefaults(), null.\u00f600000, DpiSettingDefaults.getDefaults(), null.\u00d500000, GuestAccessSettingDefaults.defaultSettings(), null.\u00d800000, LcmSettingDefaults.getDefaults(), null.\u00d600000, MgmtSettingDefaults.getDefaults(), null.oo0000, IpsSettingDefaults.getDefaults(), null.\u00d6O0000, RadiusSettingDefaults.getDefaults(), null.\u00f5O0000, UsgSettingDefaults.getDefaults());
    private static final Map<if, Map<String, java.lang.Object>> \u00d2\u00d8\u00d4000 = Map.of(if.\u00f800000, SuperMgmtSettingDefaults.dataRetentionAutoSettings());
    @ReferClasses
    public static final List<Class<?>> \u00d6\u00d8\u00d4000 = ImmutableList.of(PortalFile.class, RadiusProfile.class);
    private static final Logger whiledonew = bA.\u00f4O0000;
    public static final String \u00d5\u00d8\u00d4000 = "https://fw-download.ubnt.com/data/baresip/2885-U7PG2-v1.0.3-4513ee103bf0490a98847a19e0773295.gz";
    public static final int \u00f8\u00d8\u00d4000 = 4;
    public static final int \u00d5\u00f4\u00d4000 = 86400;
    public static final String privatefornew = "auto";
    public static final String \u00d8\u00d8\u00d4000 = "custom";
    public static final String o\u00f4\u00d4000 = "disabled";
    public static final int \u00f6\u00d8\u00d4000 = 1452;
    public static final int o\u00d8\u00d4000 = 1328;
    public static final String \u00d2\u00f4\u00d4000 = "key";
    public static final String ifdonew = "element_adopt";
    public static ooOO returndonew = ooOO.\u00d2o\u00f5000(Setting.class.getSimpleName());
    public static final Setting \u00d3\u00d30000 = (Setting)new Setting().makeImmutable();

    public static String name() {
        return "setting";
    }

    @Override
    public String getCollectionName() {
        return Setting.name();
    }

    @Override
    public AdminChangeKey getChangeKey() {
        String string = this.getSettingKey();
        if (string.startsWith("super_")) {
            return AdminChangeKey.SYSTEM;
        }
        return O.class(null.class, string).map(nullVal -> switch (nullVal) {
            case null.\u00d2o0000, null.\u00f500000 -> AdminChangeKey.INTERNET;
            case null.ifsuper, null.oO0000, null.\u00d8O0000, null.\u00f8O0000, null.\u00f6O0000, null.for, null.\u00d2O0000 -> AdminChangeKey.WIFI;
            case null.\u00d6o0000, null.\u00f600000, null.oo0000 -> AdminChangeKey.SECURITY;
            case null.\u00f5O0000, null.private, null.\u00d800000, null.\u00d3O0000 -> AdminChangeKey.DEVICE;
            case null.\u00f800000, null.null, null.\u00d600000, null.\u00d300000, null.returnsuper, null.o00000, null.\u00d200000 -> AdminChangeKey.SYSTEM;
            case null.String, null.\u00d3o0000, null.\u00d8o0000 -> AdminChangeKey.VPN;
            case null.\u00d500000 -> AdminChangeKey.HOTSPOT;
            case null.\u00d6O0000 -> AdminChangeKey.PROFILE;
            default -> AdminChangeKey.UNKNOWN;
        }).orElse(AdminChangeKey.UNKNOWN);
    }

    @Override
    public AdminChangeSection getSection() {
        String string = this.getSettingKey();
        if (string.startsWith("super_")) {
            return AdminChangeSection.SETTINGS_SUPER_SYSTEM;
        }
        return O.class(null.class, string).map(nullVal -> switch (nullVal) {
            case null.ifsuper, null.oO0000, null.\u00d8O0000, null.\u00f8O0000, null.\u00f6O0000, null.for, null.\u00d2O0000 -> AdminChangeSection.SETTINGS_WIFI;
            case null.\u00d2o0000, null.\u00f500000, null.\u00f5O0000 -> AdminChangeSection.SETTINGS_INTERNET;
            case null.\u00d6o0000, null.\u00f600000, null.oo0000 -> AdminChangeSection.SETTINGS_SECURITY;
            case null.String, null.\u00d3o0000, null.\u00d8o0000 -> AdminChangeSection.SETTINGS_VPN;
            case null.\u00d6O0000 -> AdminChangeSection.SETTINGS_RADIUS;
            case null.\u00f800000, null.private, null.\u00d800000, null.null, null.\u00d600000, null.\u00d300000, null.returnsuper, null.o00000, null.\u00d3O0000, null.\u00d200000 -> AdminChangeSection.SETTINGS_SYSTEM;
            case null.\u00d500000 -> AdminChangeSection.SETTINGS_HOTSPOT;
            default -> AdminChangeSection.SETTINGS_UNKNOWN_SITE_SETTINGS;
        }).orElse(AdminChangeSection.SETTINGS_UNKNOWN_SITE_SETTINGS);
    }

    @Override
    public Optional<N> getDepiction() {
        return N.\u00d400000(\u00d2\u00f4\u00d4000, this.getSettingKey());
    }

    @Override
    public private getChangeLogRule(oO0O oO0O2) {
        return oO0O2.super() == A.new && oO0O2.\u00d300000() != C.\u00d500000 ? com.ubnt.service.systemlog.admin.activity.changes.private.\u00d200000 : com.ubnt.service.systemlog.admin.activity.changes.private.\u00d300000().super(this.\u00d3O\u00f4000()).int(this.\u00d80\u00f4000()).\u00d4o0000(this.intreturnString()).supernew(this.\u00d4O\u00f4000()).class();
    }

    public static int mask() {
        return o\u00d40000 | \u00f6O0000 | private | \u00f5o0000 | o\u00d20000;
    }

    private static synchronized X \u00d2O\u00f4000() {
        return Object.\u00d5\u00d50000().o00000();
    }

    public static Map<String, X> getSettingPattern() {
        List<X> list = X.\u00d3o0000;
        try {
            list = X.parseJSONArray(FileCopyUtils.copyToString((Reader)new InputStreamReader(new DefaultResourceLoader().getResource("classpath:api/fields/Setting.json").getInputStream())), X.\u00d3o0000);
        }
        catch (IOException iOException) {
            whiledonew.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Unable to parse setting fields pattern!");
        }
        HashMap<String, X> hashMap = new HashMap<String, X>();
        for (X x2 : list) {
            X x3 = new X();
            for (String string : x2.keySet()) {
                Pattern pattern = Pattern.compile(x2.getString(string));
                x3.put(string, (java.lang.Object)pattern);
            }
            hashMap.put(x2.getString(\u00d2\u00f4\u00d4000), x3);
        }
        return hashMap;
    }

    private void doreturnString(X x2, String string) {
        if (x2.getX("super_fwupdate", X.\u00d3\u00d30000).containsField(string)) {
            whiledonew.warn("Trying to set read-only key 'super_fwupdate.{}'.", (java.lang.Object)string);
            throw Sanitizable.InvalidPayload.\u00d500000;
        }
    }

    @Override
    public void sanitize(X x2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : x2.keySet()) {
            java.lang.Object object;
            X x3;
            X x4;
            if (string.equals("guest_access")) {
                x4 = returndonew.getX(string, X.\u00d3\u00d30000);
                x3 = x2.getX(string, X.\u00d3\u00d30000);
                for (String string2 : x3.keySet()) {
                    if (!string2.startsWith("restricted_subnet_") && !string2.startsWith("allowed_subnet_")) continue;
                    if (!string2.matches("restricted_subnet_[\\d]+") && !string2.matches("allowed_subnet_[\\d]+")) {
                        whiledonew.warn("Invalid key in setting exists, key={}:{}", (java.lang.Object)string, (java.lang.Object)string2);
                        throw Sanitizable.InvalidPayload.\u00d500000;
                    }
                    String string3 = x3.getString(string2);
                    object = (Pattern)x4.get(string2.substring(0, string2.lastIndexOf(95) + 1));
                    if (!((Pattern)object).toString().equals("") && !((Pattern)object).matcher(string3).matches()) {
                        whiledonew.warn("Pattern not matched, '{}':{'{}':'{}'} invalid", new java.lang.Object[]{string, string2, string3});
                        throw Sanitizable.InvalidPayload.\u00d400000;
                    }
                    hashSet.add(string2);
                }
                continue;
            }
            if (string.equals("super_events")) {
                x4 = x2.getX(string, X.\u00d3\u00d30000);
                x3 = Setting.\u00d2O\u00f4000();
                ooOO ooOO2 = ooOO.\u00d8O\u00f5000("super_event", new X("event_enabled", "true|false", "alert_enabled", "true|false", "email_enabled", "true|false", "push_enabled", "true|false"));
                for (String string3 : x4.keySet()) {
                    if (!string3.startsWith("EVT_")) continue;
                    if (!x3.containsField(string3)) {
                        whiledonew.warn("Invalid key in setting exists, key={}:{}", (java.lang.Object)string, (java.lang.Object)string3);
                        throw Sanitizable.InvalidPayload.\u00d500000;
                    }
                    object = x4.getX(string3, X.\u00d3\u00d30000);
                    ooOO2.superprivateString((X)object);
                    hashSet.add(string3);
                }
                continue;
            }
            if ("mgmt".equals(string)) {
                hashSet.add("x_ssh_keys");
                continue;
            }
            if (!"super_fwupdate".equals(string)) continue;
            this.doreturnString(x2, "x_sso_token");
            this.doreturnString(x2, "allowed_controller_channels");
            this.doreturnString(x2, "allowed_firmware_channels");
        }
        hashSet.add(\u00d2\u00f4\u00d4000);
        returndonew.\u00f4O\u00f5000(x2, hashSet);
    }

    public Setting() {
    }

    public Setting(String string) {
        super(\u00d2\u00f4\u00d4000, string);
    }

    public Setting(null nullVal) {
        this(nullVal.toString());
    }

    public Setting(if if_) {
        this(if_.\u00d300000());
    }

    @Override
    public synchronized Setting append(String string, java.lang.Object object) {
        super.append(string, object);
        return this;
    }

    public boolean equalsByProperty(Setting setting, String string) {
        if (setting == null) {
            return false;
        }
        return Objects.equals(this.get(string), setting.get(string));
    }

    public String getSettingKey() {
        return this.getString(\u00d2\u00f4\u00d4000, "");
    }

    public Setting setSettingKey(String string) {
        this.put(\u00d2\u00f4\u00d4000, (java.lang.Object)string);
        return this;
    }

    public boolean hasKey(null nullVal) {
        return nullVal.toString().equals(this.getSettingKey());
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    public Setting setId(String string) {
        this.put("_id", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getSiteId() {
        return Optional.ofNullable(this.getString("site_id"));
    }

    public Setting setSiteId(String string) {
        this.put("site_id", (java.lang.Object)string);
        return this;
    }

    @Deprecated
    public List<X> getDnsFilters() {
        return this.getList("dns_filters", X.\u00d3o0000);
    }

    public Optional<D> getMailProvider() {
        return D.o00000(this.getString("provider"));
    }

    public Setting setMailProvider(D d2) {
        this.put("provider", (java.lang.Object)d2.toString());
        return this;
    }

    public boolean isEnabled() {
        return this.is("enabled", false);
    }

    public Setting setEnabled(boolean bl) {
        this.put("enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    private Set<String> \u00d3O\u00f4000() {
        String string = this.getSettingKey();
        Set set = null.\u00d200000(string).map(nullVal -> \u00d6\u00f4\u00d4000.getOrDefault(nullVal, Set.of())).orElseGet(() -> if.String(string).map(if_ -> \u00d3\u00f4\u00d4000.getOrDefault(if_, Set.of())).orElseGet(Set::of));
        return Sets.union(\u00d3\u00d8\u00d4000, (Set)set);
    }

    private Map<String, java.lang.Object> \u00d4O\u00f4000() {
        String string = this.getSettingKey();
        return null.\u00d200000(string).map(nullVal -> newdonew.getOrDefault(nullVal, Map.of())).orElseGet(() -> if.String(string).map(if_ -> \u00d2\u00d8\u00d4000.getOrDefault(if_, Map.of())).orElseGet(Map::of));
    }

    private Map<String, OOoo> \u00d80\u00f4000() {
        return null.\u00d200000(this.getSettingKey()).map(nullVal -> \u00f5\u00d8\u00d4000.getOrDefault(nullVal, Map.of())).orElseGet(Map::of);
    }

    private Map<String, String> intreturnString() {
        return null.\u00d200000(this.getSettingKey()).map(nullVal -> \u00d8\u00f4\u00d4000.getOrDefault(nullVal, Map.of())).orElseGet(Map::of);
    }

    public static class Defaults {
        public static final String \u00d200000 = "example-domain.ui.com";
        public static final String super = "UniFi";
    }
}

