/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.FileTaskCollector;
import it.sauronsoftware.cron4j.GUIDGenerator;
import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.LauncherThread;
import it.sauronsoftware.cron4j.MemoryTaskCollector;
import it.sauronsoftware.cron4j.RunnableTask;
import it.sauronsoftware.cron4j.SchedulerListener;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskCollector;
import it.sauronsoftware.cron4j.TaskExecutor;
import it.sauronsoftware.cron4j.TimerThread;
import java.io.File;
import java.util.ArrayList;
import java.util.TimeZone;

public class Scheduler {
    private String guid = GUIDGenerator.generate();
    private TimeZone timezone = null;
    private boolean daemon = false;
    private boolean started = false;
    private ArrayList collectors = new ArrayList();
    private MemoryTaskCollector memoryTaskCollector = new MemoryTaskCollector();
    private FileTaskCollector fileTaskCollector = new FileTaskCollector();
    private ArrayList listeners = new ArrayList();
    private TimerThread timer = null;
    private ArrayList launchers = null;
    private ArrayList executors = null;
    private Object lock = new Object();

    public Scheduler() {
        this.collectors.add(this.memoryTaskCollector);
        this.collectors.add(this.fileTaskCollector);
    }

    public Object getGuid() {
        return this.guid;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? this.timezone : TimeZone.getDefault();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaemon(boolean bl) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Scheduler already started");
            }
            this.daemon = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.started;
        }
    }

    public void scheduleFile(File file) {
        this.fileTaskCollector.addFile(file);
    }

    public void descheduleFile(File file) {
        this.fileTaskCollector.removeFile(file);
    }

    public File[] getScheduledFiles() {
        return this.fileTaskCollector.getFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskCollector(TaskCollector taskCollector) {
        ArrayList arrayList = this.collectors;
        synchronized (arrayList) {
            this.collectors.add(taskCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskCollector(TaskCollector taskCollector) {
        ArrayList arrayList = this.collectors;
        synchronized (arrayList) {
            this.collectors.remove(taskCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskCollector[] getTaskCollectors() {
        ArrayList arrayList = this.collectors;
        synchronized (arrayList) {
            int n = this.collectors.size() - 2;
            TaskCollector[] taskCollectorArray = new TaskCollector[n];
            for (int i = 0; i < n; ++i) {
                taskCollectorArray[i] = (TaskCollector)this.collectors.get(i + 2);
            }
            return taskCollectorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerListener[] getSchedulerListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            SchedulerListener[] schedulerListenerArray = new SchedulerListener[n];
            for (int i = 0; i < n; ++i) {
                schedulerListenerArray[i] = (SchedulerListener)this.listeners.get(i);
            }
            return schedulerListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor[] getExecutingTasks() {
        ArrayList arrayList = this.executors;
        synchronized (arrayList) {
            int n = this.executors.size();
            TaskExecutor[] taskExecutorArray = new TaskExecutor[n];
            for (int i = 0; i < n; ++i) {
                taskExecutorArray[i] = (TaskExecutor)this.executors.get(i);
            }
            return taskExecutorArray;
        }
    }

    public String schedule(String string, Runnable runnable) throws InvalidPatternException {
        return this.schedule(string, (Task)new RunnableTask(runnable));
    }

    public String schedule(String string, Task task) throws InvalidPatternException {
        return this.schedule(new SchedulingPattern(string), task);
    }

    public String schedule(SchedulingPattern schedulingPattern, Task task) {
        return this.memoryTaskCollector.add(schedulingPattern, task);
    }

    public void reschedule(Object object, String string) throws InvalidPatternException {
        this.reschedule((String)object, new SchedulingPattern(string));
    }

    public void reschedule(String string, String string2) throws InvalidPatternException {
        this.reschedule(string, new SchedulingPattern(string2));
    }

    public void reschedule(String string, SchedulingPattern schedulingPattern) {
        this.memoryTaskCollector.update(string, schedulingPattern);
    }

    public void deschedule(Object object) {
        this.deschedule((String)object);
    }

    public void deschedule(String string) {
        this.memoryTaskCollector.remove(string);
    }

    public Task getTask(String string) {
        return this.memoryTaskCollector.getTask(string);
    }

    public SchedulingPattern getSchedulingPattern(String string) {
        return this.memoryTaskCollector.getSchedulingPattern(string);
    }

    public Runnable getTaskRunnable(Object object) {
        Task task = this.getTask((String)object);
        if (task instanceof RunnableTask) {
            RunnableTask runnableTask = (RunnableTask)task;
            return runnableTask.getRunnable();
        }
        return null;
    }

    public String getTaskSchedulingPattern(Object object) {
        return this.getSchedulingPattern((String)object).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor launch(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started");
            }
            return this.spawnExecutor(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Scheduler already started");
            }
            this.launchers = new ArrayList();
            this.executors = new ArrayList();
            this.timer = new TimerThread(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList;
            Object object2;
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started");
            }
            this.timer.interrupt();
            this.tillThreadDies(this.timer);
            this.timer = null;
            while (true) {
                object2 = null;
                arrayList = this.launchers;
                synchronized (arrayList) {
                    if (this.launchers.size() == 0) {
                        break;
                    }
                    object2 = (LauncherThread)this.launchers.remove(0);
                }
                ((Thread)object2).interrupt();
                this.tillThreadDies((Thread)object2);
            }
            this.launchers = null;
            while (true) {
                object2 = null;
                arrayList = this.executors;
                synchronized (arrayList) {
                    if (this.executors.size() == 0) {
                        break;
                    }
                    object2 = (TaskExecutor)this.executors.remove(0);
                }
                if (((TaskExecutor)object2).canBeStopped()) {
                    ((TaskExecutor)object2).stop();
                }
                this.tillExecutorDies((TaskExecutor)object2);
            }
            this.executors = null;
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LauncherThread spawnLauncher(long l) {
        TaskCollector[] taskCollectorArray;
        Object object = this.collectors;
        synchronized (object) {
            int n = this.collectors.size();
            taskCollectorArray = new TaskCollector[n];
            for (int i = 0; i < n; ++i) {
                taskCollectorArray[i] = (TaskCollector)this.collectors.get(i);
            }
        }
        object = new LauncherThread(this, taskCollectorArray, l);
        ArrayList arrayList = this.launchers;
        synchronized (arrayList) {
            this.launchers.add(object);
        }
        ((Thread)object).setDaemon(this.daemon);
        ((Thread)object).start();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskExecutor spawnExecutor(Task task) {
        TaskExecutor taskExecutor = new TaskExecutor(this, task);
        ArrayList arrayList = this.executors;
        synchronized (arrayList) {
            this.executors.add(taskExecutor);
        }
        taskExecutor.start(this.daemon);
        return taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyLauncherCompleted(LauncherThread launcherThread) {
        ArrayList arrayList = this.launchers;
        synchronized (arrayList) {
            this.launchers.remove(launcherThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyExecutorCompleted(TaskExecutor taskExecutor) {
        ArrayList arrayList = this.executors;
        synchronized (arrayList) {
            this.executors.remove(taskExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTaskLaunching(TaskExecutor taskExecutor) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                SchedulerListener schedulerListener = (SchedulerListener)this.listeners.get(i);
                schedulerListener.taskLaunching(taskExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTaskSucceeded(TaskExecutor taskExecutor) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                SchedulerListener schedulerListener = (SchedulerListener)this.listeners.get(i);
                schedulerListener.taskSucceeded(taskExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTaskFailed(TaskExecutor taskExecutor, Throwable throwable) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    SchedulerListener schedulerListener = (SchedulerListener)this.listeners.get(i);
                    schedulerListener.taskFailed(taskExecutor, throwable);
                }
            } else {
                throwable.printStackTrace();
            }
        }
    }

    private void tillThreadDies(Thread thread) {
        boolean bl = false;
        do {
            try {
                thread.join();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!bl);
    }

    private void tillExecutorDies(TaskExecutor taskExecutor) {
        boolean bl = false;
        do {
            try {
                taskExecutor.join();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!bl);
    }
}

